/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.eventhubs.core;

import com.azure.messaging.eventhubs.EventProcessorClient;
import com.azure.spring.eventhubs.core.processor.EventHubsProcessorFactory;
import com.azure.spring.service.eventhubs.processor.EventProcessingListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.Lifecycle;

public class EventHubsProcessorContainer
implements Lifecycle,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventHubsProcessorContainer.class);
    private final EventHubsProcessorFactory processorFactory;
    private final List<EventProcessorClient> clients = new ArrayList<EventProcessorClient>();
    private final AtomicBoolean isRunning = new AtomicBoolean(false);

    public EventHubsProcessorContainer(EventHubsProcessorFactory processorFactory) {
        this.processorFactory = processorFactory;
    }

    public void destroy() {
        this.stop();
    }

    public void start() {
        if (!this.isRunning.compareAndSet(false, true)) {
            LOGGER.info("Event processors container is already running");
            return;
        }
        this.clients.forEach(EventProcessorClient::start);
    }

    public void stop() {
        if (!this.isRunning.compareAndSet(true, false)) {
            LOGGER.info("Event processors container has already stopped");
            return;
        }
        this.clients.forEach(EventProcessorClient::stop);
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public EventProcessorClient subscribe(String eventHubName, String consumerGroup, EventProcessingListener listener) {
        EventProcessorClient processor = this.processorFactory.createProcessor(eventHubName, consumerGroup, listener);
        processor.start();
        this.clients.add(processor);
        return processor;
    }
}

