/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.eventhubs.core.properties;

import com.azure.spring.core.aware.authentication.ConnectionStringAware;
import com.azure.spring.core.connectionstring.implementation.EventHubsConnectionString;
import com.azure.spring.core.properties.AbstractAzureAmqpSdkProperties;
import com.azure.spring.service.eventhubs.properties.EventHubsCommonDescriptor;

abstract class CommonProperties
extends AbstractAzureAmqpSdkProperties
implements EventHubsCommonDescriptor,
ConnectionStringAware {
    private String domainName = "servicebus.windows.net";
    private String namespace;
    private String eventHubName;
    private String connectionString;
    private String customEndpointAddress;

    CommonProperties() {
    }

    private String extractFqdnFromConnectionString() {
        if (this.connectionString == null) {
            return null;
        }
        return new EventHubsConnectionString(this.connectionString).getFullyQualifiedNamespace();
    }

    private String extractEventHubNameFromConnectionString() {
        if (this.connectionString == null) {
            return null;
        }
        return new EventHubsConnectionString(this.connectionString).getEntityPath();
    }

    public String getFQDN() {
        return this.namespace == null ? this.extractFqdnFromConnectionString() : this.namespace + "." + this.domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getEventHubName() {
        return this.eventHubName == null ? this.extractEventHubNameFromConnectionString() : this.eventHubName;
    }

    public void setEventHubName(String eventHubName) {
        this.eventHubName = eventHubName;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getCustomEndpointAddress() {
        return this.customEndpointAddress;
    }

    public void setCustomEndpointAddress(String customEndpointAddress) {
        this.customEndpointAddress = customEndpointAddress;
    }
}

