/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.eventhubs.core.properties.merger;

import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.util.AzurePropertiesUtils;
import com.azure.spring.core.properties.util.PropertyMapper;
import com.azure.spring.eventhubs.core.properties.NamespaceProperties;
import com.azure.spring.eventhubs.core.properties.ProcessorProperties;
import com.azure.spring.service.core.ParentMerger;
import com.azure.spring.service.eventhubs.properties.EventHubsProcessorDescriptor;
import java.util.Map;

public class ProcessorPropertiesParentMerger
implements ParentMerger<ProcessorProperties, NamespaceProperties> {
    public ProcessorProperties mergeParent(ProcessorProperties child, NamespaceProperties parent) {
        ProcessorProperties properties = new ProcessorProperties();
        if (child == null && parent == null) {
            return properties;
        }
        if (child == null) {
            child = new ProcessorProperties();
        }
        if (parent == null) {
            parent = new NamespaceProperties();
        }
        PropertyMapper propertyMapper = new PropertyMapper();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)parent, (AzureProperties)child, (AzureProperties)properties);
        propertyMapper.from((Object)parent.getDomainName()).to(x$0 -> properties.setDomainName((String)x$0));
        propertyMapper.from((Object)parent.getNamespace()).to(x$0 -> properties.setNamespace((String)x$0));
        propertyMapper.from((Object)parent.getEventHubName()).to(x$0 -> properties.setEventHubName((String)x$0));
        propertyMapper.from((Object)parent.getConnectionString()).to(x$0 -> properties.setConnectionString((String)x$0));
        propertyMapper.from((Object)parent.getCustomEndpointAddress()).to(x$0 -> properties.setCustomEndpointAddress((String)x$0));
        propertyMapper.from((Object)child.getDomainName()).to(x$0 -> properties.setDomainName((String)x$0));
        propertyMapper.from((Object)child.getNamespace()).to(x$0 -> properties.setNamespace((String)x$0));
        propertyMapper.from((Object)child.getEventHubName()).to(x$0 -> properties.setEventHubName((String)x$0));
        propertyMapper.from((Object)child.getConnectionString()).to(x$0 -> properties.setConnectionString((String)x$0));
        propertyMapper.from((Object)child.getCustomEndpointAddress()).to(x$0 -> properties.setCustomEndpointAddress((String)x$0));
        propertyMapper.from((Object)child.getPrefetchCount()).to(properties::setPrefetchCount);
        propertyMapper.from((Object)child.getConsumerGroup()).to(properties::setConsumerGroup);
        propertyMapper.from((Object)child.getTrackLastEnqueuedEventProperties()).to(properties::setTrackLastEnqueuedEventProperties);
        propertyMapper.from(child.getInitialPartitionEventPosition()).to(m -> properties.getInitialPartitionEventPosition().putAll((Map<String, EventHubsProcessorDescriptor.StartPosition>)m));
        propertyMapper.from((Object)child.getPartitionOwnershipExpirationInterval()).to(properties::setPartitionOwnershipExpirationInterval);
        propertyMapper.from((Object)child.getBatch().getMaxSize()).to(arg_0 -> ((EventHubsProcessorDescriptor.Batch)properties.getBatch()).setMaxSize(arg_0));
        propertyMapper.from((Object)child.getBatch().getMaxWaitTime()).to(arg_0 -> ((EventHubsProcessorDescriptor.Batch)properties.getBatch()).setMaxWaitTime(arg_0));
        propertyMapper.from((Object)child.getLoadBalancing().getStrategy()).to(arg_0 -> ((EventHubsProcessorDescriptor.LoadBalancing)properties.getLoadBalancing()).setStrategy(arg_0));
        propertyMapper.from((Object)child.getLoadBalancing().getUpdateInterval()).to(arg_0 -> ((EventHubsProcessorDescriptor.LoadBalancing)properties.getLoadBalancing()).setUpdateInterval(arg_0));
        return properties;
    }
}

