/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.eventhubs.support.converter;

import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.models.EventBatchContext;
import com.azure.spring.messaging.converter.AbstractAzureMessageConverter;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class EventHubBatchMessageConverter
extends AbstractAzureMessageConverter<EventBatchContext, EventData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventHubBatchMessageConverter.class);
    private static final Set<String> SYSTEM_HEADERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("azure_partition_key", "azure_eventhub_enqueued_time", "azure_eventhub_offset", "azure_eventhub_sequence_number")));

    protected EventData fromString(String payload) {
        return new EventData(payload.getBytes(StandardCharsets.UTF_8));
    }

    protected EventData fromByte(byte[] payload) {
        return new EventData(payload);
    }

    protected void setCustomHeaders(MessageHeaders headers, EventData azureMessage) {
        super.setCustomHeaders(headers, (Object)azureMessage);
        headers.forEach((key, value) -> {
            if (SYSTEM_HEADERS.contains(key)) {
                LOGGER.warn("System property {}({}) is not allowed to be defined and will be ignored.", key, value);
            } else {
                azureMessage.getProperties().put(key, value.toString());
            }
        });
    }

    protected Object getPayload(EventBatchContext azureMessage) {
        return azureMessage.getEvents().stream().map(EventData::getBody).collect(Collectors.toList());
    }

    protected <U> Message<?> internalToMessage(EventBatchContext azureMessage, Map<String, Object> headers, Class<U> targetPayloadClass) {
        List payload = (List)this.getPayload(azureMessage);
        Assert.isTrue((payload != null ? 1 : 0) != 0, (String)"payload must not be null");
        if (targetPayloadClass.isInstance(azureMessage)) {
            return MessageBuilder.withPayload((Object)azureMessage).copyHeaders(headers).build();
        }
        if (targetPayloadClass == String.class) {
            List payLoadList = payload.stream().map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).collect(Collectors.toList());
            return MessageBuilder.withPayload(payLoadList).copyHeaders(headers).build();
        }
        if (targetPayloadClass == byte[].class) {
            return MessageBuilder.withPayload((Object)payload).copyHeaders(headers).build();
        }
        List payLoadList = payload.stream().map(bytes -> this.fromPayload(bytes, targetPayloadClass)).collect(Collectors.toList());
        return MessageBuilder.withPayload(payLoadList).copyHeaders(headers).build();
    }

    protected Map<String, Object> buildCustomHeaders(EventBatchContext azureMessage) {
        Map headers = super.buildCustomHeaders((Object)azureMessage);
        List events = azureMessage.getEvents();
        ArrayList<Instant> enqueueTimeList = new ArrayList<Instant>();
        ArrayList<Long> offSetList = new ArrayList<Long>();
        ArrayList<Long> sequenceNumberList = new ArrayList<Long>();
        ArrayList<String> partitionKeyList = new ArrayList<String>();
        ArrayList<Map> batchConvertedSystemProperties = new ArrayList<Map>();
        ArrayList<Map> batchConvertedApplicationProperties = new ArrayList<Map>();
        for (EventData event : events) {
            enqueueTimeList.add(event.getEnqueuedTime());
            offSetList.add(event.getOffset());
            sequenceNumberList.add(event.getSequenceNumber());
            partitionKeyList.add(event.getPartitionKey());
            batchConvertedSystemProperties.add(event.getSystemProperties());
            batchConvertedApplicationProperties.add(event.getProperties());
        }
        headers.put("azure_eventhub_enqueued_time", enqueueTimeList);
        headers.put("azure_eventhub_offset", offSetList);
        headers.put("azure_eventhub_sequence_number", sequenceNumberList);
        headers.put("azure_partition_key", partitionKeyList);
        headers.put("azure_eventhub_batch_converted_system_properties", batchConvertedSystemProperties);
        headers.put("azure_eventhub_batch_converted_application_properties", batchConvertedApplicationProperties);
        return headers;
    }
}

