/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.eventhubs.checkpoint;

import com.azure.spring.eventhubs.checkpoint.BatchCheckpointManager;
import com.azure.spring.eventhubs.checkpoint.EventCheckpointManager;
import com.azure.spring.eventhubs.checkpoint.ManualCheckpointManager;
import com.azure.spring.eventhubs.checkpoint.PartitionCountCheckpointManager;
import com.azure.spring.eventhubs.checkpoint.RecordCheckpointManager;
import com.azure.spring.eventhubs.checkpoint.TimeCheckpointManager;
import com.azure.spring.messaging.ListenerMode;
import com.azure.spring.messaging.checkpoint.CheckpointConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CheckpointManagers {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointManagers.class);

    public static EventCheckpointManager of(CheckpointConfig checkpointConfig, ListenerMode listenerMode) {
        if (listenerMode.equals((Object)ListenerMode.BATCH)) {
            switch (checkpointConfig.getMode()) {
                case BATCH: {
                    return new BatchCheckpointManager(checkpointConfig);
                }
                case MANUAL: {
                    return new ManualCheckpointManager(checkpointConfig);
                }
            }
            throw new IllegalArgumentException("Illegal checkpoint mode when building CheckpointManager in batch consuming mode!");
        }
        switch (checkpointConfig.getMode()) {
            case TIME: {
                return new TimeCheckpointManager(checkpointConfig);
            }
            case RECORD: {
                return new RecordCheckpointManager(checkpointConfig);
            }
            case PARTITION_COUNT: {
                return new PartitionCountCheckpointManager(checkpointConfig);
            }
            case MANUAL: {
                return new ManualCheckpointManager(checkpointConfig);
            }
        }
        LOG.warn("Does not support checkpoint mode:{} while consume mode is:{} ", (Object)checkpointConfig.getMode().name(), (Object)listenerMode);
        throw new IllegalArgumentException("Illegal checkpoint mode when building CheckpointManager");
    }
}

