/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.eventhubs.core;

import com.azure.messaging.eventhubs.EventProcessorClient;
import com.azure.spring.eventhubs.core.processor.EventHubsProcessorFactory;
import com.azure.spring.messaging.ConsumerIdentifier;
import com.azure.spring.service.eventhubs.processor.EventProcessingListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.Lifecycle;

public class EventHubsProcessorContainer
implements Lifecycle,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventHubsProcessorContainer.class);
    private final EventHubsProcessorFactory processorFactory;
    private final Map<ConsumerIdentifier, EventProcessorClient> clients = new HashMap<ConsumerIdentifier, EventProcessorClient>();
    private final AtomicBoolean isRunning = new AtomicBoolean(false);

    public EventHubsProcessorContainer(EventHubsProcessorFactory processorFactory) {
        this.processorFactory = processorFactory;
    }

    public void destroy() {
        this.stop();
    }

    public void start() {
        if (!this.isRunning.compareAndSet(false, true)) {
            LOGGER.info("Event processors container is already running");
            return;
        }
        this.clients.values().forEach(EventProcessorClient::start);
    }

    public void stop() {
        if (!this.isRunning.compareAndSet(true, false)) {
            LOGGER.info("Event processors container has already stopped");
            return;
        }
        this.clients.values().forEach(EventProcessorClient::stop);
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public EventProcessorClient subscribe(String eventHubName, String consumerGroup, EventProcessingListener listener) {
        EventProcessorClient processor = this.processorFactory.createProcessor(eventHubName, consumerGroup, listener);
        processor.start();
        this.clients.computeIfAbsent(new ConsumerIdentifier(eventHubName, consumerGroup), k -> processor);
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsubscribe(String eventHubName, String consumerGroup) {
        Map<ConsumerIdentifier, EventProcessorClient> map = this.clients;
        synchronized (map) {
            EventProcessorClient processor = this.clients.remove(new ConsumerIdentifier(eventHubName, consumerGroup));
            if (processor == null) {
                LOGGER.warn("No EventProcessorClient for event hub {}, consumer group {}", (Object)eventHubName, (Object)consumerGroup);
                return false;
            }
            processor.stop();
            return true;
        }
    }
}

