/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.eventhubs.core.processor;

import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventProcessorClient;
import com.azure.messaging.eventhubs.EventProcessorClientBuilder;
import com.azure.spring.core.AzureSpringIdentifier;
import com.azure.spring.eventhubs.core.processor.EventHubsProcessorFactory;
import com.azure.spring.eventhubs.core.properties.NamespaceProperties;
import com.azure.spring.eventhubs.core.properties.ProcessorProperties;
import com.azure.spring.eventhubs.core.properties.merger.ProcessorPropertiesParentMerger;
import com.azure.spring.messaging.ConsumerIdentifier;
import com.azure.spring.messaging.PropertiesSupplier;
import com.azure.spring.service.eventhubs.processor.EventProcessingListener;
import com.azure.spring.service.implementation.eventhubs.factory.EventProcessorClientBuilderFactory;
import com.azure.spring.service.implementation.eventhubs.properties.EventProcessorClientProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class DefaultEventHubsNamespaceProcessorFactory
implements EventHubsProcessorFactory,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEventHubsNamespaceProcessorFactory.class);
    private final List<EventHubsProcessorFactory.Listener> listeners = new ArrayList<EventHubsProcessorFactory.Listener>();
    private final NamespaceProperties namespaceProperties;
    private final CheckpointStore checkpointStore;
    private final PropertiesSupplier<ConsumerIdentifier, ProcessorProperties> propertiesSupplier;
    private final Map<ConsumerIdentifier, EventProcessorClient> processorClientMap = new ConcurrentHashMap<ConsumerIdentifier, EventProcessorClient>();
    private final ProcessorPropertiesParentMerger propertiesMerger = new ProcessorPropertiesParentMerger();

    public DefaultEventHubsNamespaceProcessorFactory(CheckpointStore checkpointStore) {
        this(checkpointStore, null, null);
    }

    public DefaultEventHubsNamespaceProcessorFactory(CheckpointStore checkpointStore, NamespaceProperties namespaceProperties) {
        this(checkpointStore, namespaceProperties, (PropertiesSupplier<ConsumerIdentifier, ProcessorProperties>)((PropertiesSupplier)key -> null));
    }

    public DefaultEventHubsNamespaceProcessorFactory(CheckpointStore checkpointStore, PropertiesSupplier<ConsumerIdentifier, ProcessorProperties> supplier) {
        this(checkpointStore, null, supplier);
    }

    public DefaultEventHubsNamespaceProcessorFactory(CheckpointStore checkpointStore, NamespaceProperties namespaceProperties, PropertiesSupplier<ConsumerIdentifier, ProcessorProperties> supplier) {
        Assert.notNull((Object)checkpointStore, (String)"CheckpointStore must be provided.");
        this.checkpointStore = checkpointStore;
        this.namespaceProperties = namespaceProperties;
        this.propertiesSupplier = supplier == null ? key -> null : supplier;
    }

    @Override
    public EventProcessorClient createProcessor(@NonNull String eventHub, @NonNull String consumerGroup, @NonNull EventProcessingListener listener) {
        return this.doCreateProcessor(eventHub, consumerGroup, listener, (ProcessorProperties)((Object)this.propertiesSupplier.getProperties((Object)new ConsumerIdentifier(eventHub, consumerGroup))));
    }

    public void destroy() {
        this.processorClientMap.forEach((t, client) -> {
            this.listeners.forEach(l -> l.processorRemoved(t.getDestination(), t.getGroup(), (EventProcessorClient)client));
            client.stop();
        });
        this.processorClientMap.clear();
        this.listeners.clear();
    }

    private EventProcessorClient doCreateProcessor(@NonNull String eventHub, @NonNull String consumerGroup, @NonNull EventProcessingListener listener, @Nullable ProcessorProperties properties) {
        ConsumerIdentifier key = new ConsumerIdentifier(eventHub, consumerGroup);
        return this.processorClientMap.computeIfAbsent(key, k -> {
            ProcessorProperties processorProperties = this.propertiesMerger.mergeParent(properties, this.namespaceProperties);
            processorProperties.setEventHubName(k.getDestination());
            processorProperties.setConsumerGroup(k.getGroup());
            EventProcessorClientBuilderFactory factory = new EventProcessorClientBuilderFactory((EventProcessorClientProperties)processorProperties, this.checkpointStore, listener);
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_INTEGRATION_EVENT_HUBS);
            EventProcessorClient client = ((EventProcessorClientBuilder)factory.build()).buildEventProcessorClient();
            LOGGER.info("EventProcessor created for event hub '{}' with consumer group '{}'", (Object)k.getDestination(), (Object)k.getGroup());
            this.listeners.forEach(l -> l.processorAdded(k.getDestination(), k.getGroup(), client));
            return client;
        });
    }

    @Override
    public void addListener(EventHubsProcessorFactory.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(EventHubsProcessorFactory.Listener listener) {
        return this.listeners.remove(listener);
    }
}

