/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.eventhubs.core.producer;

import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.spring.core.AzureSpringIdentifier;
import com.azure.spring.eventhubs.core.producer.EventHubsProducerFactory;
import com.azure.spring.eventhubs.core.properties.NamespaceProperties;
import com.azure.spring.eventhubs.core.properties.ProducerProperties;
import com.azure.spring.eventhubs.core.properties.merger.ProducerPropertiesParentMerger;
import com.azure.spring.messaging.PropertiesSupplier;
import com.azure.spring.service.implementation.eventhubs.factory.EventHubClientBuilderFactory;
import com.azure.spring.service.implementation.eventhubs.properties.EventHubClientCommonProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.Nullable;

public final class DefaultEventHubsNamespaceProducerFactory
implements EventHubsProducerFactory,
DisposableBean {
    private final List<EventHubsProducerFactory.Listener> listeners = new ArrayList<EventHubsProducerFactory.Listener>();
    private final NamespaceProperties namespaceProperties;
    private final PropertiesSupplier<String, ProducerProperties> propertiesSupplier;
    private final Map<String, EventHubProducerAsyncClient> clients = new ConcurrentHashMap<String, EventHubProducerAsyncClient>();
    private final ProducerPropertiesParentMerger parentMerger = new ProducerPropertiesParentMerger();

    public DefaultEventHubsNamespaceProducerFactory(NamespaceProperties namespaceProperties) {
        this(namespaceProperties, (PropertiesSupplier<String, ProducerProperties>)((PropertiesSupplier)key -> null));
    }

    public DefaultEventHubsNamespaceProducerFactory(NamespaceProperties namespaceProperties, PropertiesSupplier<String, ProducerProperties> supplier) {
        this.namespaceProperties = namespaceProperties;
        this.propertiesSupplier = supplier == null ? key -> null : supplier;
    }

    @Override
    public EventHubProducerAsyncClient createProducer(String eventHub) {
        return this.doCreateProducer(eventHub, (ProducerProperties)((Object)this.propertiesSupplier.getProperties((Object)eventHub)));
    }

    private EventHubProducerAsyncClient doCreateProducer(String eventHub, @Nullable ProducerProperties properties) {
        return this.clients.computeIfAbsent(eventHub, entityName -> {
            ProducerProperties producerProperties = this.parentMerger.mergeParent(properties, this.namespaceProperties);
            producerProperties.setEventHubName((String)entityName);
            EventHubClientBuilderFactory factory = new EventHubClientBuilderFactory((EventHubClientCommonProperties)producerProperties);
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_INTEGRATION_EVENT_HUBS);
            EventHubProducerAsyncClient producerClient = ((EventHubClientBuilder)factory.build()).buildAsyncProducerClient();
            this.listeners.forEach(l -> l.producerAdded((String)entityName, producerClient));
            return producerClient;
        });
    }

    @Override
    public void addListener(EventHubsProducerFactory.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(EventHubsProducerFactory.Listener listener) {
        return this.listeners.remove(listener);
    }

    public void destroy() {
        this.clients.forEach((name, client) -> {
            this.listeners.forEach(l -> l.producerRemoved((String)name, (EventHubProducerAsyncClient)client));
            client.close();
        });
        this.clients.clear();
        this.listeners.clear();
    }
}

