/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.eventhubs.core.properties.merger;

import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.PropertyMapper;
import com.azure.spring.core.util.AzurePropertiesUtils;
import com.azure.spring.eventhubs.core.properties.NamespaceProperties;
import com.azure.spring.eventhubs.core.properties.ProcessorProperties;
import com.azure.spring.service.eventhubs.properties.EventBatchProperties;
import com.azure.spring.service.eventhubs.properties.LoadBalancingProperties;
import com.azure.spring.service.eventhubs.properties.StartPositionProperties;
import com.azure.spring.service.implementation.core.ParentMerger;
import java.util.Map;

public class ProcessorPropertiesParentMerger
implements ParentMerger<ProcessorProperties, NamespaceProperties> {
    public ProcessorProperties mergeParent(ProcessorProperties child, NamespaceProperties parent) {
        ProcessorProperties properties = new ProcessorProperties();
        if (child == null && parent == null) {
            return properties;
        }
        if (child == null) {
            child = new ProcessorProperties();
        }
        if (parent == null) {
            parent = new NamespaceProperties();
        }
        PropertyMapper propertyMapper = new PropertyMapper();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)parent, (AzureProperties)child, (AzureProperties)properties);
        propertyMapper.from((Object)parent.getDomainName()).to(x$0 -> properties.setDomainName((String)x$0));
        propertyMapper.from((Object)parent.getNamespace()).to(x$0 -> properties.setNamespace((String)x$0));
        propertyMapper.from((Object)parent.getEventHubName()).to(x$0 -> properties.setEventHubName((String)x$0));
        propertyMapper.from((Object)parent.getConnectionString()).to(x$0 -> properties.setConnectionString((String)x$0));
        propertyMapper.from((Object)parent.getCustomEndpointAddress()).to(x$0 -> properties.setCustomEndpointAddress((String)x$0));
        propertyMapper.from((Object)child.getDomainName()).to(x$0 -> properties.setDomainName((String)x$0));
        propertyMapper.from((Object)child.getNamespace()).to(x$0 -> properties.setNamespace((String)x$0));
        propertyMapper.from((Object)child.getEventHubName()).to(x$0 -> properties.setEventHubName((String)x$0));
        propertyMapper.from((Object)child.getConnectionString()).to(x$0 -> properties.setConnectionString((String)x$0));
        propertyMapper.from((Object)child.getCustomEndpointAddress()).to(x$0 -> properties.setCustomEndpointAddress((String)x$0));
        propertyMapper.from((Object)child.getPrefetchCount()).to(properties::setPrefetchCount);
        propertyMapper.from((Object)child.getConsumerGroup()).to(properties::setConsumerGroup);
        propertyMapper.from((Object)child.getTrackLastEnqueuedEventProperties()).to(properties::setTrackLastEnqueuedEventProperties);
        propertyMapper.from(child.getInitialPartitionEventPosition()).to(m -> properties.getInitialPartitionEventPosition().putAll((Map<String, StartPositionProperties>)m));
        propertyMapper.from((Object)child.getBatch().getMaxSize()).to(arg_0 -> ((EventBatchProperties)properties.getBatch()).setMaxSize(arg_0));
        propertyMapper.from((Object)child.getBatch().getMaxWaitTime()).to(arg_0 -> ((EventBatchProperties)properties.getBatch()).setMaxWaitTime(arg_0));
        propertyMapper.from((Object)child.getLoadBalancing().getPartitionOwnershipExpirationInterval()).to(arg_0 -> ((LoadBalancingProperties)properties.getLoadBalancing()).setPartitionOwnershipExpirationInterval(arg_0));
        propertyMapper.from((Object)child.getLoadBalancing().getStrategy()).to(arg_0 -> ((LoadBalancingProperties)properties.getLoadBalancing()).setStrategy(arg_0));
        propertyMapper.from((Object)child.getLoadBalancing().getUpdateInterval()).to(arg_0 -> ((LoadBalancingProperties)properties.getLoadBalancing()).setUpdateInterval(arg_0));
        return properties;
    }
}

