/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.eventhubs.core;

import com.azure.core.credential.TokenCredential;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.service.implementation.eventhubs.factory.EventHubClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.eventhubs.properties.EventHubClientCommonProperties;
import com.azure.spring.messaging.PropertiesSupplier;
import com.azure.spring.messaging.eventhubs.core.EventHubsProducerFactory;
import com.azure.spring.messaging.eventhubs.core.properties.NamespaceProperties;
import com.azure.spring.messaging.eventhubs.core.properties.ProducerProperties;
import com.azure.spring.messaging.eventhubs.implementation.properties.merger.ProducerPropertiesParentMerger;
import com.azure.spring.messaging.implementation.config.AzureMessagingBootstrapConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.Nullable;

public final class DefaultEventHubsNamespaceProducerFactory
implements EventHubsProducerFactory,
DisposableBean {
    private final List<EventHubsProducerFactory.Listener> listeners = new ArrayList<EventHubsProducerFactory.Listener>();
    private final NamespaceProperties namespaceProperties;
    private final PropertiesSupplier<String, ProducerProperties> propertiesSupplier;
    private final Map<String, EventHubProducerAsyncClient> clients = new ConcurrentHashMap<String, EventHubProducerAsyncClient>();
    private final ProducerPropertiesParentMerger parentMerger = new ProducerPropertiesParentMerger();
    private final List<AzureServiceClientBuilderCustomizer<EventHubClientBuilder>> customizers = new ArrayList<AzureServiceClientBuilderCustomizer<EventHubClientBuilder>>();
    private final Map<String, List<AzureServiceClientBuilderCustomizer<EventHubClientBuilder>>> dedicatedCustomizers = new HashMap<String, List<AzureServiceClientBuilderCustomizer<EventHubClientBuilder>>>();
    private AzureCredentialResolver<TokenCredential> tokenCredentialResolver = null;
    private TokenCredential defaultCredential = null;

    public DefaultEventHubsNamespaceProducerFactory(NamespaceProperties namespaceProperties) {
        this(namespaceProperties, (PropertiesSupplier<String, ProducerProperties>)((PropertiesSupplier)key -> null));
    }

    public DefaultEventHubsNamespaceProducerFactory(NamespaceProperties namespaceProperties, PropertiesSupplier<String, ProducerProperties> supplier) {
        this.namespaceProperties = namespaceProperties;
        this.propertiesSupplier = supplier == null ? key -> null : supplier;
    }

    @Override
    public EventHubProducerAsyncClient createProducer(String eventHub) {
        return this.doCreateProducer(eventHub, (ProducerProperties)((Object)this.propertiesSupplier.getProperties((Object)eventHub)));
    }

    private EventHubProducerAsyncClient doCreateProducer(String eventHub, @Nullable ProducerProperties properties) {
        return this.clients.computeIfAbsent(eventHub, entityName -> {
            ProducerProperties producerProperties = this.parentMerger.merge(properties, this.namespaceProperties);
            producerProperties.setEventHubName((String)entityName);
            EventHubClientBuilderFactory factory = new EventHubClientBuilderFactory((EventHubClientCommonProperties)producerProperties);
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_INTEGRATION_EVENT_HUBS);
            factory.setTokenCredentialResolver(this.tokenCredentialResolver);
            factory.setDefaultTokenCredential(this.defaultCredential);
            EventHubClientBuilder builder = (EventHubClientBuilder)factory.build();
            this.customizeBuilder(eventHub, builder);
            EventHubProducerAsyncClient producerClient = builder.buildAsyncProducerClient();
            this.listeners.forEach(l -> l.producerAdded((String)entityName, producerClient));
            return producerClient;
        });
    }

    @Override
    public void addListener(EventHubsProducerFactory.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(EventHubsProducerFactory.Listener listener) {
        return this.listeners.remove(listener);
    }

    public void destroy() {
        this.clients.forEach((name, client) -> {
            this.listeners.forEach(l -> l.producerRemoved((String)name, (EventHubProducerAsyncClient)client));
            client.close();
        });
        this.clients.clear();
        this.listeners.clear();
    }

    public void setTokenCredentialResolver(AzureCredentialResolver<TokenCredential> tokenCredentialResolver) {
        this.tokenCredentialResolver = tokenCredentialResolver;
    }

    public void setDefaultCredential(TokenCredential defaultCredential) {
        this.defaultCredential = defaultCredential;
    }

    public void addBuilderCustomizer(AzureServiceClientBuilderCustomizer<EventHubClientBuilder> customizer) {
        if (customizer == null) {
            AzureMessagingBootstrapConfiguration.LOGGER.debug("The provided customizer is null, will ignore it.");
            return;
        }
        this.customizers.add(customizer);
    }

    public void addBuilderCustomizer(String eventHub, AzureServiceClientBuilderCustomizer<EventHubClientBuilder> customizer) {
        if (customizer == null) {
            AzureMessagingBootstrapConfiguration.LOGGER.debug("The provided customizer is null, will ignore it.");
            return;
        }
        this.dedicatedCustomizers.computeIfAbsent(eventHub, key -> new ArrayList()).add(customizer);
    }

    private void customizeBuilder(String eventHub, EventHubClientBuilder builder) {
        this.customizers.forEach(customizer -> customizer.customize((Object)builder));
        ((List)this.dedicatedCustomizers.getOrDefault(eventHub, new ArrayList())).forEach(customizer -> customizer.customize((Object)builder));
    }
}

