/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.eventhubs.implementation.core.config;

import com.azure.messaging.eventhubs.models.ErrorContext;
import com.azure.spring.cloud.service.eventhubs.consumer.EventHubsErrorHandler;
import com.azure.spring.messaging.eventhubs.core.EventHubsProcessorFactory;
import com.azure.spring.messaging.eventhubs.core.listener.EventHubsMessageListenerContainer;
import com.azure.spring.messaging.eventhubs.core.properties.EventHubsContainerProperties;
import com.azure.spring.messaging.implementation.config.AzureListenerEndpoint;
import com.azure.spring.messaging.implementation.config.AzureMessageListenerContainerFactoryAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubsMessageListenerContainerFactory
extends AzureMessageListenerContainerFactoryAdapter<EventHubsMessageListenerContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventHubsMessageListenerContainerFactory.class);
    private final EventHubsProcessorFactory processorFactory;
    private EventHubsErrorHandler errorHandler = new LoggingErrorHandler();

    public EventHubsMessageListenerContainerFactory(EventHubsProcessorFactory processorFactory) {
        this.processorFactory = processorFactory;
    }

    protected EventHubsMessageListenerContainer createContainerInstance(AzureListenerEndpoint endpoint) {
        EventHubsContainerProperties containerProperties = new EventHubsContainerProperties();
        containerProperties.setEventHubName(endpoint.getDestination());
        containerProperties.setConsumerGroup(endpoint.getGroup());
        containerProperties.setErrorHandler(this.errorHandler);
        return new EventHubsMessageListenerContainer(this.processorFactory, containerProperties);
    }

    public void setErrorHandler(EventHubsErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    static class LoggingErrorHandler
    implements EventHubsErrorHandler {
        LoggingErrorHandler() {
        }

        public void accept(ErrorContext errorContext) {
            LOGGER.error("Error occurred on partition: {}. Error: {}", (Object)errorContext.getPartitionContext().getPartitionId(), (Object)errorContext.getThrowable());
        }
    }
}

