/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.eventhubs.implementation.core.config;

import com.azure.spring.messaging.converter.AzureMessageConverter;
import com.azure.spring.messaging.eventhubs.implementation.core.config.AbstractEventHubsListenerEndpoint;
import com.azure.spring.messaging.eventhubs.implementation.core.listener.adapter.BatchMessagingMessageListenerAdapter;
import com.azure.spring.messaging.eventhubs.implementation.core.listener.adapter.RecordMessagingMessageListenerAdapter;
import com.azure.spring.messaging.eventhubs.implementation.support.converter.EventHubsBatchMessageConverter;
import com.azure.spring.messaging.eventhubs.implementation.support.converter.EventHubsMessageConverter;
import com.azure.spring.messaging.implementation.config.MethodAzureListenerEndpoint;
import com.azure.spring.messaging.implementation.listener.adapter.MessagingMessageListenerAdapter;
import com.azure.spring.messaging.listener.MessageListenerContainer;
import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringValueResolver;

public class MethodEventHubsListenerEndpoint
extends AbstractEventHubsListenerEndpoint
implements MethodAzureListenerEndpoint {
    @Nullable
    private Object bean;
    @Nullable
    private Method method;
    @Nullable
    protected MessageHandlerMethodFactory messageHandlerMethodFactory;
    @Nullable
    private StringValueResolver embeddedValueResolver;

    public void setBeanFactory(@Nullable BeanFactory beanFactory) {
        if (this.embeddedValueResolver == null && beanFactory instanceof ConfigurableBeanFactory) {
            this.embeddedValueResolver = new EmbeddedValueResolver((ConfigurableBeanFactory)beanFactory);
        }
    }

    protected StringBuilder getEndpointDescription() {
        return super.getEndpointDescription().append(" | bean='").append(this.bean).append("'").append(" | method='").append(this.method).append("'");
    }

    protected MessagingMessageListenerAdapter createMessageListener(MessageListenerContainer listenerContainer, AzureMessageConverter<?, ?> messageConverter) {
        Assert.state((this.messageHandlerMethodFactory != null ? 1 : 0) != 0, (String)"Could not create message listener - MessageHandlerMethodFactory not set");
        MessagingMessageListenerAdapter messageListener = this.createMessageListenerInstance(messageConverter);
        Object bean = this.getBean();
        Method method = this.getMethod();
        Assert.state((bean != null && method != null ? 1 : 0) != 0, (String)"No bean+method set on endpoint");
        InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(bean, method);
        messageListener.setHandlerMethod(invocableHandlerMethod);
        return messageListener;
    }

    protected MessagingMessageListenerAdapter createMessageListenerInstance(@Nullable AzureMessageConverter<?, ?> messageConverter) {
        MessagingMessageListenerAdapter listener;
        if (this.isBatchListener()) {
            BatchMessagingMessageListenerAdapter messageListener = new BatchMessagingMessageListenerAdapter();
            if (messageConverter instanceof EventHubsBatchMessageConverter) {
                messageListener.setMessageConverter(messageConverter);
            }
            listener = messageListener;
        } else {
            RecordMessagingMessageListenerAdapter messageListener = new RecordMessagingMessageListenerAdapter();
            if (messageConverter instanceof EventHubsMessageConverter) {
                messageListener.setMessageConverter(messageConverter);
            }
            listener = messageListener;
        }
        return listener;
    }

    @Nullable
    public Object getBean() {
        return this.bean;
    }

    public void setBean(@Nullable Object bean) {
        this.bean = bean;
    }

    @Nullable
    public Method getMethod() {
        return this.method;
    }

    public void setMethod(@Nullable Method method) {
        this.method = method;
    }

    public void setMessageHandlerMethodFactory(@Nullable MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }
}

