/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.eventhubs.implementation.core.listener.adapter;

import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.messaging.eventhubs.models.PartitionContext;
import com.azure.spring.cloud.service.eventhubs.consumer.EventHubsRecordMessageListener;
import com.azure.spring.messaging.converter.AzureMessageConverter;
import com.azure.spring.messaging.eventhubs.implementation.support.converter.EventHubsMessageConverter;
import com.azure.spring.messaging.implementation.listener.adapter.MessagingMessageListenerAdapter;
import java.util.HashMap;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public class RecordMessagingMessageListenerAdapter
extends MessagingMessageListenerAdapter
implements EventHubsRecordMessageListener {
    public RecordMessagingMessageListenerAdapter() {
        this.messageConverter = new EventHubsMessageConverter();
    }

    public void onMessage(EventContext eventContext) {
        PartitionContext partition = eventContext.getPartitionContext();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("azure_raw_partition_id", partition.getPartitionId());
        headers.put("azure_eventhubs_last_enqueued_event_properties", (String)eventContext.getLastEnqueuedEventProperties());
        EventData event = eventContext.getEventData();
        Message message = this.getMessageConverter().toMessage((Object)event, (Map)new MessageHeaders(headers), this.payloadType);
        this.invokeHandler(message);
    }

    public AzureMessageConverter<EventData, EventData> getMessageConverter() {
        return super.getMessageConverter();
    }
}

