/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.servicebus.support.converter;

import com.azure.core.util.BinaryData;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.spring.messaging.converter.AbstractAzureMessageConverter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ServiceBusMessageConverter
extends AbstractAzureMessageConverter<ServiceBusReceivedMessage, ServiceBusMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBusMessageConverter.class);
    private final ObjectMapper objectMapper;

    public ServiceBusMessageConverter() {
        this.objectMapper = OBJECT_MAPPER;
    }

    public ServiceBusMessageConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected byte[] getPayload(ServiceBusReceivedMessage azureMessage) {
        BinaryData body = azureMessage.getBody();
        return body == null ? null : body.toBytes();
    }

    protected ServiceBusMessage fromString(String payload) {
        return new ServiceBusMessage(payload);
    }

    protected ServiceBusMessage fromByte(byte[] payload) {
        return new ServiceBusMessage(payload);
    }

    protected void setCustomHeaders(MessageHeaders headers, ServiceBusMessage message) {
        HashMap<String, Object> copySpringMessageHeaders = new HashMap<String, Object>();
        copySpringMessageHeaders.putAll((Map<String, Object>)headers);
        this.getAndRemove(copySpringMessageHeaders, "id", UUID.class).ifPresent(val -> message.setMessageId(val.toString()));
        this.getAndRemove(copySpringMessageHeaders, "contentType").ifPresent(arg_0 -> ((ServiceBusMessage)message).setContentType(arg_0));
        this.getAndRemove(copySpringMessageHeaders, "replyChannel").ifPresent(arg_0 -> ((ServiceBusMessage)message).setReplyTo(arg_0));
        this.getAndRemove(copySpringMessageHeaders, "raw_id").ifPresent(val -> {
            message.setMessageId(val);
            this.logOverriddenHeaders("raw_id", "id", headers);
        });
        this.getAndRemove(copySpringMessageHeaders, "x-delay", Integer.class).map(Duration::ofMillis).map(Instant.now()::plus).map(ins -> OffsetDateTime.ofInstant(ins, ZoneId.systemDefault())).ifPresent(arg_0 -> ((ServiceBusMessage)message).setScheduledEnqueueTime(arg_0));
        this.getAndRemove(copySpringMessageHeaders, "azure_service_bus_message_id").ifPresent(val -> {
            message.setMessageId(val);
            if (!this.logOverriddenHeaders("azure_service_bus_message_id", "raw_id", headers).booleanValue()) {
                this.logOverriddenHeaders("azure_service_bus_message_id", "id", headers);
            }
        });
        this.getAndRemove(copySpringMessageHeaders, "azure_service_bus_time_to_live", Duration.class).ifPresent(arg_0 -> ((ServiceBusMessage)message).setTimeToLive(arg_0));
        this.getAndRemove(copySpringMessageHeaders, "azure_service_bus_scheduled_enqueue_time", OffsetDateTime.class).ifPresent(val -> {
            message.setScheduledEnqueueTime(val);
            this.logOverriddenHeaders("azure_service_bus_scheduled_enqueue_time", "x-delay", headers);
        });
        this.getAndRemove(copySpringMessageHeaders, "azure_service_bus_session_id").ifPresent(arg_0 -> ((ServiceBusMessage)message).setSessionId(arg_0));
        this.getAndRemove(copySpringMessageHeaders, "azure_service_bus_correlation_id").ifPresent(arg_0 -> ((ServiceBusMessage)message).setCorrelationId(arg_0));
        this.getAndRemove(copySpringMessageHeaders, "azure_service_bus_to").ifPresent(arg_0 -> ((ServiceBusMessage)message).setTo(arg_0));
        this.getAndRemove(copySpringMessageHeaders, "azure_service_bus_reply_to_session_id").ifPresent(arg_0 -> ((ServiceBusMessage)message).setReplyToSessionId(arg_0));
        if (StringUtils.hasText((String)message.getSessionId())) {
            if (!ObjectUtils.isEmpty((Object)headers.get((Object)"azure_service_bus_partition_key")) && !ObjectUtils.nullSafeEquals((Object)message.getSessionId(), (Object)headers.get((Object)"azure_service_bus_partition_key"))) {
                LOGGER.warn("Different session id and partition key are set in the message header, and the partition key header will be overwritten by the session id header.");
            }
            message.setPartitionKey(message.getSessionId());
            if (copySpringMessageHeaders.containsKey("azure_service_bus_partition_key")) {
                copySpringMessageHeaders.remove("azure_service_bus_partition_key");
            }
        } else {
            this.getAndRemove(copySpringMessageHeaders, "azure_service_bus_partition_key").ifPresent(arg_0 -> ((ServiceBusMessage)message).setPartitionKey(arg_0));
        }
        copySpringMessageHeaders.forEach((key, value) -> message.getApplicationProperties().put(key, value.toString()));
    }

    protected Map<String, Object> buildCustomHeaders(ServiceBusReceivedMessage message) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        this.setValueIfHasText(headers, "id", message.getMessageId());
        this.setValueIfHasText(headers, "contentType", message.getContentType());
        this.setValueIfHasText(headers, "replyChannel", message.getReplyTo());
        this.setValueIfHasText(headers, "raw_id", message.getMessageId());
        this.setValueIfHasText(headers, "azure_service_bus_correlation_id", message.getCorrelationId());
        this.setValueIfHasText(headers, "azure_service_bus_message_id", message.getMessageId());
        this.setValueIfHasText(headers, "azure_service_bus_partition_key", message.getPartitionKey());
        this.setValueIfHasText(headers, "azure_service_bus_to", message.getTo());
        this.setValueIfPresent(headers, "azure_service_bus_time_to_live", message.getTimeToLive());
        this.setValueIfPresent(headers, "azure_service_bus_scheduled_enqueue_time", message.getScheduledEnqueueTime());
        this.setValueIfHasText(headers, "azure_service_bus_reply_to_session_id", message.getReplyToSessionId());
        this.setValueIfHasText(headers, "azure_service_bus_session_id", message.getSessionId());
        message.getApplicationProperties().forEach((key, value) -> headers.putIfAbsent((String)key, value));
        return Collections.unmodifiableMap(headers);
    }

    private Optional<String> getAndRemove(Map<String, Object> copySpringMessageHeaders, String key) {
        return this.getAndRemove(copySpringMessageHeaders, key, String.class).filter(StringUtils::hasText);
    }

    private <T> Optional<T> getAndRemove(Map<String, Object> copySpringMessageHeaders, String key, Class<T> clazz) {
        return Optional.ofNullable(clazz.cast(copySpringMessageHeaders.remove(key)));
    }

    private Boolean logOverriddenHeaders(String currentHeader, String overriddenHeader, MessageHeaders springMessageHeaders) {
        Boolean isExisted = false;
        if (springMessageHeaders.containsKey((Object)overriddenHeader)) {
            isExisted = true;
            LOGGER.warn("{} header detected, usage of {} header will be overridden", (Object)currentHeader, (Object)overriddenHeader);
        }
        return isExisted;
    }

    private void setValueIfHasText(Map<String, Object> map, String key, String value) {
        Optional.ofNullable(value).filter(StringUtils::hasText).ifPresent(s -> map.put(key, s));
    }

    private void setValueIfPresent(Map<String, Object> map, String key, Object value) {
        Optional.ofNullable(value).ifPresent(s -> map.put(key, s));
    }
}

