/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.servicebus.core;

import com.azure.messaging.servicebus.ServiceBusProcessorClient;
import com.azure.spring.messaging.ConsumerIdentifier;
import com.azure.spring.service.servicebus.processor.MessageProcessingListener;
import com.azure.spring.servicebus.core.processor.ServiceBusProcessorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.Lifecycle;

public class ServiceBusProcessorContainer
implements Lifecycle,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBusProcessorContainer.class);
    private final ServiceBusProcessorFactory processorFactory;
    private final Map<ConsumerIdentifier, ServiceBusProcessorClient> clients = new HashMap<ConsumerIdentifier, ServiceBusProcessorClient>();
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final List<ServiceBusProcessorFactory.Listener> listeners = new ArrayList<ServiceBusProcessorFactory.Listener>();

    public ServiceBusProcessorContainer(ServiceBusProcessorFactory processorFactory) {
        this.processorFactory = processorFactory;
    }

    public void destroy() throws Exception {
        this.clients.values().forEach(ServiceBusProcessorClient::close);
        this.clients.clear();
    }

    public void start() {
        if (!this.isRunning.compareAndSet(false, true)) {
            LOGGER.info("Service Bus processors container is already running");
            return;
        }
        this.clients.values().forEach(ServiceBusProcessorClient::start);
    }

    public void stop() {
        if (!this.isRunning.compareAndSet(true, false)) {
            LOGGER.info("Service Bus processors container has already stopped");
            return;
        }
        this.clients.values().forEach(ServiceBusProcessorClient::stop);
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public ServiceBusProcessorClient subscribe(String queue, MessageProcessingListener listener) {
        ServiceBusProcessorClient processor = this.processorFactory.createProcessor(queue, listener);
        processor.start();
        this.listeners.forEach(l -> l.processorAdded(queue, null, processor));
        this.clients.computeIfAbsent(new ConsumerIdentifier(queue), k -> processor);
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsubscribe(String queue) {
        Map<ConsumerIdentifier, ServiceBusProcessorClient> map = this.clients;
        synchronized (map) {
            ServiceBusProcessorClient processor = this.clients.remove(new ConsumerIdentifier(queue));
            if (processor == null) {
                LOGGER.warn("No ServiceBusProcessorClient for Service Bus queue {}", (Object)queue);
                return false;
            }
            processor.close();
            this.listeners.forEach(l -> l.processorRemoved(queue, null, processor));
            return true;
        }
    }

    public ServiceBusProcessorClient subscribe(String topic, String subscription, MessageProcessingListener listener) {
        ServiceBusProcessorClient processor = this.processorFactory.createProcessor(topic, subscription, listener);
        processor.start();
        this.listeners.forEach(l -> l.processorAdded(topic, subscription, processor));
        this.clients.computeIfAbsent(new ConsumerIdentifier(topic, subscription), k -> processor);
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsubscribe(String topic, String subscription) {
        Map<ConsumerIdentifier, ServiceBusProcessorClient> map = this.clients;
        synchronized (map) {
            ServiceBusProcessorClient processor = this.clients.remove(new ConsumerIdentifier(topic, subscription));
            if (processor == null) {
                LOGGER.warn("No ServiceBusProcessorClient for Service Bus topic {}, subscription {}", (Object)topic, (Object)subscription);
                return false;
            }
            processor.close();
            this.listeners.forEach(l -> l.processorRemoved(topic, subscription, processor));
            return true;
        }
    }
}

