/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.servicebus.core;

import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import com.azure.spring.messaging.PartitionSupplier;
import com.azure.spring.messaging.core.SendOperation;
import com.azure.spring.service.servicebus.properties.ServiceBusEntityType;
import com.azure.spring.servicebus.core.producer.ServiceBusProducerFactory;
import com.azure.spring.servicebus.support.converter.ServiceBusMessageConverter;
import java.util.Objects;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class ServiceBusTemplate
implements SendOperation {
    private static final ServiceBusMessageConverter DEFAULT_CONVERTER = new ServiceBusMessageConverter();
    private final ServiceBusProducerFactory producerFactory;
    private ServiceBusMessageConverter messageConverter = DEFAULT_CONVERTER;
    private ServiceBusEntityType defaultEntityType;

    public ServiceBusTemplate(@NonNull ServiceBusProducerFactory producerFactory) {
        this.producerFactory = producerFactory;
    }

    public <U> Mono<Void> sendAsync(String destination, Message<U> message, PartitionSupplier partitionSupplier) {
        Assert.hasText((String)destination, (String)"destination can't be null or empty");
        ServiceBusSenderAsyncClient senderAsyncClient = this.producerFactory.createProducer(destination, this.defaultEntityType);
        ServiceBusMessage serviceBusMessage = (ServiceBusMessage)this.messageConverter.fromMessage(message, ServiceBusMessage.class);
        if (Objects.nonNull(serviceBusMessage) && !StringUtils.hasText((String)serviceBusMessage.getPartitionKey())) {
            String partitionKey = this.getPartitionKey(partitionSupplier);
            serviceBusMessage.setPartitionKey(partitionKey);
        }
        return senderAsyncClient.sendMessage(serviceBusMessage);
    }

    public void setMessageConverter(ServiceBusMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public ServiceBusMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    private String getPartitionKey(PartitionSupplier partitionSupplier) {
        if (partitionSupplier == null) {
            return "";
        }
        if (StringUtils.hasText((String)partitionSupplier.getPartitionKey())) {
            return partitionSupplier.getPartitionKey();
        }
        if (StringUtils.hasText((String)partitionSupplier.getPartitionId())) {
            return partitionSupplier.getPartitionId();
        }
        return "";
    }

    public void setDefaultEntityType(ServiceBusEntityType entityType) {
        this.defaultEntityType = entityType;
    }
}

