/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.servicebus.core.processor;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusProcessorClient;
import com.azure.spring.core.AzureSpringIdentifier;
import com.azure.spring.messaging.ConsumerIdentifier;
import com.azure.spring.messaging.PropertiesSupplier;
import com.azure.spring.service.implementation.servicebus.factory.ServiceBusProcessorClientBuilderFactory;
import com.azure.spring.service.implementation.servicebus.factory.ServiceBusSessionProcessorClientBuilderFactory;
import com.azure.spring.service.implementation.servicebus.properties.ServiceBusProcessorClientProperties;
import com.azure.spring.service.servicebus.processor.MessageProcessingListener;
import com.azure.spring.service.servicebus.properties.ServiceBusEntityType;
import com.azure.spring.servicebus.core.processor.ServiceBusProcessorFactory;
import com.azure.spring.servicebus.core.properties.NamespaceProperties;
import com.azure.spring.servicebus.core.properties.ProcessorProperties;
import com.azure.spring.servicebus.core.properties.merger.ProcessorPropertiesParentMerger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.Nullable;

public final class DefaultServiceBusNamespaceProcessorFactory
implements ServiceBusProcessorFactory,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceBusNamespaceProcessorFactory.class);
    private final Map<ConsumerIdentifier, ServiceBusProcessorClient> processorMap = new ConcurrentHashMap<ConsumerIdentifier, ServiceBusProcessorClient>();
    private final List<ServiceBusProcessorFactory.Listener> listeners = new ArrayList<ServiceBusProcessorFactory.Listener>();
    private final NamespaceProperties namespaceProperties;
    private final PropertiesSupplier<ConsumerIdentifier, ProcessorProperties> propertiesSupplier;
    private final ProcessorPropertiesParentMerger propertiesMerger = new ProcessorPropertiesParentMerger();

    public DefaultServiceBusNamespaceProcessorFactory(NamespaceProperties namespaceProperties) {
        this(namespaceProperties, (PropertiesSupplier<ConsumerIdentifier, ProcessorProperties>)((PropertiesSupplier)key -> null));
    }

    public DefaultServiceBusNamespaceProcessorFactory(NamespaceProperties namespaceProperties, PropertiesSupplier<ConsumerIdentifier, ProcessorProperties> supplier) {
        this.namespaceProperties = namespaceProperties;
        this.propertiesSupplier = supplier == null ? key -> null : supplier;
    }

    private void close(Map<ConsumerIdentifier, ServiceBusProcessorClient> map, Consumer<ServiceBusProcessorClient> close) {
        map.forEach((t, p) -> {
            try {
                this.listeners.forEach(l -> l.processorRemoved(t.getDestination(), t.getGroup(), (ServiceBusProcessorClient)p));
                close.accept((ServiceBusProcessorClient)p);
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to clean service bus queue client factory", (Throwable)ex);
            }
        });
    }

    public void destroy() {
        this.close(this.processorMap, ServiceBusProcessorClient::close);
        this.processorMap.clear();
        this.listeners.clear();
    }

    @Override
    public ServiceBusProcessorClient createProcessor(String queue, MessageProcessingListener messageProcessingListener) {
        return this.doCreateProcessor(queue, null, messageProcessingListener, (ProcessorProperties)((Object)this.propertiesSupplier.getProperties((Object)new ConsumerIdentifier(queue))));
    }

    @Override
    public ServiceBusProcessorClient createProcessor(String topic, String subscription, MessageProcessingListener messageProcessingListener) {
        return this.doCreateProcessor(topic, subscription, messageProcessingListener, (ProcessorProperties)((Object)this.propertiesSupplier.getProperties((Object)new ConsumerIdentifier(topic, subscription))));
    }

    private ServiceBusProcessorClient doCreateProcessor(String name, String subscription, MessageProcessingListener listener, @Nullable ProcessorProperties properties) {
        ConsumerIdentifier key = new ConsumerIdentifier(name, subscription);
        return this.processorMap.computeIfAbsent(key, k -> {
            ServiceBusProcessorClient client;
            ProcessorProperties processorProperties = this.propertiesMerger.mergeParent(properties, this.namespaceProperties);
            processorProperties.setAutoComplete(false);
            processorProperties.setEntityName(k.getDestination());
            if (!k.hasGroup()) {
                processorProperties.setEntityType(ServiceBusEntityType.QUEUE);
            } else {
                processorProperties.setEntityType(ServiceBusEntityType.TOPIC);
                processorProperties.setSubscriptionName(k.getGroup());
            }
            if (Boolean.TRUE.equals(processorProperties.getSessionEnabled())) {
                ServiceBusSessionProcessorClientBuilderFactory factory = new ServiceBusSessionProcessorClientBuilderFactory((ServiceBusProcessorClientProperties)processorProperties, listener);
                factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_INTEGRATION_SERVICE_BUS);
                client = ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)factory.build()).buildProcessorClient();
            } else {
                ServiceBusProcessorClientBuilderFactory factory = new ServiceBusProcessorClientBuilderFactory((ServiceBusProcessorClientProperties)processorProperties, listener);
                factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_INTEGRATION_SERVICE_BUS);
                client = ((ServiceBusClientBuilder.ServiceBusProcessorClientBuilder)factory.build()).buildProcessorClient();
            }
            this.listeners.forEach(l -> l.processorAdded(k.getDestination(), k.getGroup(), client));
            return client;
        });
    }

    @Override
    public void addListener(ServiceBusProcessorFactory.Listener listener) {
        this.listeners.add(listener);
    }
}

