/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.servicebus.core.producer;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import com.azure.spring.core.AzureSpringIdentifier;
import com.azure.spring.messaging.PropertiesSupplier;
import com.azure.spring.service.implementation.servicebus.factory.ServiceBusSenderClientBuilderFactory;
import com.azure.spring.service.implementation.servicebus.properties.ServiceBusSenderClientProperties;
import com.azure.spring.service.servicebus.properties.ServiceBusEntityType;
import com.azure.spring.servicebus.core.producer.ServiceBusProducerFactory;
import com.azure.spring.servicebus.core.properties.NamespaceProperties;
import com.azure.spring.servicebus.core.properties.ProducerProperties;
import com.azure.spring.servicebus.core.properties.merger.SenderPropertiesParentMerger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.Nullable;

public final class DefaultServiceBusNamespaceProducerFactory
implements ServiceBusProducerFactory,
DisposableBean {
    private final List<ServiceBusProducerFactory.Listener> listeners = new ArrayList<ServiceBusProducerFactory.Listener>();
    private final NamespaceProperties namespaceProperties;
    private final PropertiesSupplier<String, ProducerProperties> propertiesSupplier;
    private final Map<String, ServiceBusSenderAsyncClient> clients = new ConcurrentHashMap<String, ServiceBusSenderAsyncClient>();
    private final SenderPropertiesParentMerger parentMerger = new SenderPropertiesParentMerger();

    public DefaultServiceBusNamespaceProducerFactory(NamespaceProperties namespaceProperties) {
        this(namespaceProperties, (PropertiesSupplier<String, ProducerProperties>)((PropertiesSupplier)key -> null));
    }

    public DefaultServiceBusNamespaceProducerFactory(NamespaceProperties namespaceProperties, PropertiesSupplier<String, ProducerProperties> supplier) {
        this.namespaceProperties = namespaceProperties;
        this.propertiesSupplier = supplier == null ? key -> null : supplier;
    }

    @Override
    public ServiceBusSenderAsyncClient createProducer(String name) {
        return this.createProducer(name, null);
    }

    @Override
    public ServiceBusSenderAsyncClient createProducer(String name, ServiceBusEntityType entityType) {
        ProducerProperties producerProperties;
        ProducerProperties producerProperties2 = producerProperties = this.propertiesSupplier.getProperties((Object)name) != null ? (ProducerProperties)((Object)this.propertiesSupplier.getProperties((Object)name)) : new ProducerProperties();
        if (entityType != null) {
            producerProperties.setEntityType(entityType);
        }
        return this.doCreateProducer(name, producerProperties);
    }

    @Override
    public void addListener(ServiceBusProducerFactory.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(ServiceBusProducerFactory.Listener listener) {
        return this.listeners.remove(listener);
    }

    public void destroy() {
        this.clients.forEach((name, producer) -> {
            this.listeners.forEach(l -> l.producerRemoved((String)name, (ServiceBusSenderAsyncClient)producer));
            producer.close();
        });
        this.clients.clear();
        this.listeners.clear();
    }

    private ServiceBusSenderAsyncClient doCreateProducer(String name, @Nullable ProducerProperties properties) {
        return this.clients.computeIfAbsent(name, entityName -> {
            ProducerProperties producerProperties = this.parentMerger.mergeParent(properties, this.namespaceProperties);
            producerProperties.setEntityName((String)entityName);
            ServiceBusSenderClientBuilderFactory factory = new ServiceBusSenderClientBuilderFactory((ServiceBusSenderClientProperties)producerProperties);
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_INTEGRATION_SERVICE_BUS);
            ServiceBusSenderAsyncClient producerClient = ((ServiceBusClientBuilder.ServiceBusSenderClientBuilder)factory.build()).buildAsyncClient();
            this.listeners.forEach(l -> l.producerAdded((String)entityName, producerClient));
            return producerClient;
        });
    }
}

