/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.servicebus.core.properties.merger;

import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.PropertyMapper;
import com.azure.spring.core.util.AzurePropertiesUtils;
import com.azure.spring.service.implementation.core.ParentMerger;
import com.azure.spring.servicebus.core.properties.NamespaceProperties;
import com.azure.spring.servicebus.core.properties.ProcessorProperties;

public class ProcessorPropertiesParentMerger
implements ParentMerger<ProcessorProperties, NamespaceProperties> {
    public ProcessorProperties mergeParent(ProcessorProperties child, NamespaceProperties parent) {
        ProcessorProperties properties = new ProcessorProperties();
        if (child == null && parent == null) {
            return properties;
        }
        if (child == null) {
            child = new ProcessorProperties();
        }
        if (parent == null) {
            parent = new NamespaceProperties();
        }
        PropertyMapper propertyMapper = new PropertyMapper();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)parent, (AzureProperties)child, (AzureProperties)properties);
        propertyMapper.from((Object)parent.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)parent.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)parent.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)parent.getEntityName()).to(properties::setEntityName);
        propertyMapper.from((Object)parent.getEntityType()).to(properties::setEntityType);
        propertyMapper.from((Object)child.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)child.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)child.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)child.getEntityName()).to(properties::setEntityName);
        propertyMapper.from((Object)child.getEntityType()).to(properties::setEntityType);
        propertyMapper.from((Object)child.getMaxConcurrentSessions()).to(properties::setMaxConcurrentSessions);
        propertyMapper.from((Object)child.getMaxConcurrentCalls()).to(properties::setMaxConcurrentCalls);
        propertyMapper.from((Object)child.getSessionEnabled()).to(properties::setSessionAware);
        propertyMapper.from((Object)child.getAutoComplete()).to(properties::setAutoComplete);
        propertyMapper.from((Object)child.getPrefetchCount()).to(properties::setPrefetchCount);
        propertyMapper.from((Object)child.getSubQueue()).to(properties::setSubQueue);
        propertyMapper.from((Object)child.getReceiveMode()).to(properties::setReceiveMode);
        propertyMapper.from((Object)child.getSubscriptionName()).to(properties::setSubscriptionName);
        propertyMapper.from((Object)child.getMaxAutoLockRenewDuration()).to(properties::setMaxAutoLockRenewDuration);
        return properties;
    }
}

