/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.servicebus.core.listener;

import com.azure.messaging.servicebus.ServiceBusProcessorClient;
import com.azure.spring.cloud.service.listener.MessageListener;
import com.azure.spring.cloud.service.servicebus.consumer.ServiceBusErrorHandler;
import com.azure.spring.messaging.listener.AbstractMessageListenerContainer;
import com.azure.spring.messaging.servicebus.core.ServiceBusProcessorFactory;
import com.azure.spring.messaging.servicebus.core.properties.ServiceBusContainerProperties;
import org.springframework.util.StringUtils;

public class ServiceBusMessageListenerContainer
extends AbstractMessageListenerContainer {
    private final ServiceBusProcessorFactory processorFactory;
    private final ServiceBusContainerProperties containerProperties;
    private ServiceBusErrorHandler errorHandler;
    private ServiceBusProcessorClient delegate;

    public ServiceBusMessageListenerContainer(ServiceBusProcessorFactory processorFactory, ServiceBusContainerProperties containerProperties) {
        this.processorFactory = processorFactory;
        this.containerProperties = containerProperties == null ? new ServiceBusContainerProperties() : containerProperties;
    }

    protected void doStart() {
        String entityName = this.containerProperties.getEntityName();
        String subscriptionName = this.containerProperties.getSubscriptionName();
        if (this.errorHandler != null) {
            this.containerProperties.setErrorHandler(this.errorHandler);
        }
        this.delegate = StringUtils.hasText((String)subscriptionName) ? this.processorFactory.createProcessor(entityName, subscriptionName, this.containerProperties) : this.processorFactory.createProcessor(entityName, this.containerProperties);
        this.delegate.start();
    }

    protected void doStop() {
        if (this.delegate != null) {
            this.delegate.stop();
        }
    }

    public void setupMessageListener(MessageListener<?> messageListener) {
        this.containerProperties.setMessageListener(messageListener);
    }

    public ServiceBusContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    public void setErrorHandler(ServiceBusErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
}

