/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.servicebus.implementation.support.converter;

import com.azure.core.util.BinaryData;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.messaging.implementation.converter.AbstractJacksonAzureMessageConverter;
import com.azure.spring.messaging.implementation.converter.ObjectMapperHolder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ServiceBusMessageConverter
extends AbstractJacksonAzureMessageConverter<ServiceBusReceivedMessage, ServiceBusMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBusMessageConverter.class);
    private final ObjectMapper objectMapper;

    public ServiceBusMessageConverter() {
        this(ObjectMapperHolder.OBJECT_MAPPER);
    }

    public ServiceBusMessageConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected byte[] getPayload(ServiceBusReceivedMessage azureMessage) {
        BinaryData body = azureMessage.getBody();
        return body.toBytes();
    }

    protected ServiceBusMessage fromString(String payload) {
        return new ServiceBusMessage(payload);
    }

    protected ServiceBusMessage fromByte(byte[] payload) {
        return new ServiceBusMessage(payload);
    }

    protected void setCustomHeaders(MessageHeaders headers, ServiceBusMessage message) {
        HashMap<String, Object> headersCopy = new HashMap<String, Object>((Map<String, Object>)headers);
        PropertyMapper propertyMapper = new PropertyMapper();
        propertyMapper.from(headersCopy.remove("id")).to(id -> message.setMessageId(id.toString()));
        propertyMapper.from(headersCopy.remove("contentType")).to(type -> message.setContentType(type.toString()));
        propertyMapper.from(headersCopy.remove("replyChannel")).to(channel -> message.setReplyTo(channel.toString()));
        propertyMapper.from(headersCopy.remove("x-delay")).to(time -> {
            Instant instant = Instant.now().plus(Duration.ofMillis(((Integer)time).intValue()));
            OffsetDateTime dateTime = OffsetDateTime.ofInstant(instant, ZoneId.systemDefault());
            message.setScheduledEnqueueTime(dateTime);
        });
        propertyMapper.from(headersCopy.remove("azure_service_bus_message_id")).to(id -> {
            message.setMessageId(id.toString());
            this.logOverriddenHeaders("azure_service_bus_message_id", "id", headers);
        });
        propertyMapper.from(headersCopy.remove("azure_service_bus_time_to_live")).to(time -> message.setTimeToLive((Duration)time));
        propertyMapper.from(headersCopy.remove("azure_service_bus_scheduled_enqueue_time")).to(time -> {
            message.setScheduledEnqueueTime((OffsetDateTime)time);
            this.logOverriddenHeaders("azure_service_bus_scheduled_enqueue_time", "x-delay", headers);
        });
        propertyMapper.from(headersCopy.remove("azure_service_bus_session_id")).to(id -> message.setSessionId(id.toString()));
        propertyMapper.from(headersCopy.remove("azure_service_bus_correlation_id")).to(id -> message.setCorrelationId(id.toString()));
        propertyMapper.from(headersCopy.remove("azure_service_bus_to")).to(to -> message.setTo(to.toString()));
        propertyMapper.from(headersCopy.remove("azure_service_bus_reply_to_session_id")).to(id -> message.setReplyToSessionId(id.toString()));
        if (StringUtils.hasText((String)message.getSessionId())) {
            if (!ObjectUtils.isEmpty((Object)headers.get((Object)"azure_service_bus_partition_key")) && !ObjectUtils.nullSafeEquals((Object)message.getSessionId(), (Object)headers.get((Object)"azure_service_bus_partition_key"))) {
                LOGGER.warn("Different session id and partition key are set in the message header, and the partition key header will be overwritten by the session id header.");
            }
            message.setPartitionKey(message.getSessionId());
            headersCopy.remove("azure_service_bus_partition_key");
        } else {
            propertyMapper.from(headersCopy.remove("azure_service_bus_partition_key")).to(key -> message.setPartitionKey(key.toString()));
        }
        propertyMapper.from(headersCopy.remove("azure_service_bus_subject")).to(subject -> message.setSubject(subject.toString()));
        headersCopy.forEach((key, value) -> message.getApplicationProperties().put(key, value.toString()));
    }

    protected Map<String, Object> buildCustomHeaders(ServiceBusReceivedMessage message) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        this.setValueIfHasText(headers, "id", message.getMessageId());
        this.setValueIfHasText(headers, "contentType", message.getContentType());
        this.setValueIfHasText(headers, "replyChannel", message.getReplyTo());
        this.setValueIfHasText(headers, "azure_service_bus_correlation_id", message.getCorrelationId());
        this.setValueIfHasText(headers, "azure_service_bus_message_id", message.getMessageId());
        this.setValueIfHasText(headers, "azure_service_bus_partition_key", message.getPartitionKey());
        this.setValueIfHasText(headers, "azure_service_bus_to", message.getTo());
        this.setValueIfPresent(headers, "azure_service_bus_time_to_live", message.getTimeToLive());
        this.setValueIfPresent(headers, "azure_service_bus_scheduled_enqueue_time", message.getScheduledEnqueueTime());
        this.setValueIfHasText(headers, "azure_service_bus_reply_to_session_id", message.getReplyToSessionId());
        this.setValueIfHasText(headers, "azure_service_bus_session_id", message.getSessionId());
        this.setValueIfHasText(headers, "azure_service_bus_dead_letter_error_description", message.getDeadLetterErrorDescription());
        this.setValueIfHasText(headers, "azure_service_bus_dead_letter_reason", message.getDeadLetterReason());
        this.setValueIfHasText(headers, "azure_service_bus_dead_letter_source", message.getDeadLetterSource());
        this.setValueIfPresent(headers, "azure_service_bus_delivery_count", message.getDeliveryCount());
        this.setValueIfPresent(headers, "azure_service_bus_enqueued_sequence_number", message.getEnqueuedSequenceNumber());
        this.setValueIfPresent(headers, "azure_service_bus_enqueued_time", message.getEnqueuedTime());
        this.setValueIfPresent(headers, "azure_service_bus_expires_at", message.getExpiresAt());
        this.setValueIfHasText(headers, "azure_service_bus_lock_token", message.getLockToken());
        this.setValueIfPresent(headers, "azure_service_bus_locked_until", message.getLockedUntil());
        this.setValueIfPresent(headers, "azure_service_bus_sequence_number", message.getSequenceNumber());
        this.setValueIfPresent(headers, "azure_service_bus_state", message.getState());
        this.setValueIfHasText(headers, "azure_service_bus_subject", message.getSubject());
        message.getApplicationProperties().forEach(headers::putIfAbsent);
        return Collections.unmodifiableMap(headers);
    }

    private void logOverriddenHeaders(String currentHeader, String overriddenHeader, MessageHeaders springMessageHeaders) {
        if (springMessageHeaders.containsKey((Object)overriddenHeader)) {
            LOGGER.warn("{} header detected, usage of {} header will be overridden", (Object)currentHeader, (Object)overriddenHeader);
        }
    }

    private void setValueIfHasText(Map<String, Object> map, String key, String value) {
        Optional.ofNullable(value).filter(StringUtils::hasText).ifPresent(s -> map.put(key, s));
    }

    private void setValueIfPresent(Map<String, Object> map, String key, Object value) {
        Optional.ofNullable(value).ifPresent(s -> map.put(key, s));
    }
}

