/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.servicebus.implementation.properties.merger;

import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.implementation.util.AzurePropertiesUtils;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.core.PropertiesMerger;
import com.azure.spring.messaging.servicebus.core.properties.ProcessorProperties;

public class ProcessorPropertiesMerger
implements PropertiesMerger<ProcessorProperties, ProcessorProperties> {
    public ProcessorProperties merge(ProcessorProperties first, ProcessorProperties second) {
        ProcessorProperties properties = new ProcessorProperties();
        if (first == null && second == null) {
            return properties;
        }
        if (first == null) {
            first = new ProcessorProperties();
        }
        if (second == null) {
            second = new ProcessorProperties();
        }
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)second, (AzureProperties)first, (AzureProperties)properties);
        ProcessorPropertiesMerger.copyProcessorPropertiesIfNotNull(second, properties);
        ProcessorPropertiesMerger.copyProcessorPropertiesIfNotNull(first, properties);
        return properties;
    }

    public static void copyProcessorPropertiesIfNotNull(ProcessorProperties source, ProcessorProperties target) {
        PropertyMapper propertyMapper = new PropertyMapper();
        propertyMapper.from((Object)source.getDomainName()).to(target::setDomainName);
        propertyMapper.from((Object)source.getNamespace()).to(target::setNamespace);
        propertyMapper.from((Object)source.getConnectionString()).to(target::setConnectionString);
        propertyMapper.from((Object)source.getEntityName()).to(target::setEntityName);
        propertyMapper.from((Object)source.getEntityType()).to(target::setEntityType);
        propertyMapper.from((Object)source.getMaxConcurrentSessions()).to(target::setMaxConcurrentSessions);
        propertyMapper.from((Object)source.getMaxConcurrentCalls()).to(target::setMaxConcurrentCalls);
        propertyMapper.from((Object)source.getCustomEndpointAddress()).to(target::setCustomEndpointAddress);
        propertyMapper.from((Object)source.getSessionEnabled()).to(target::setSessionEnabled);
        propertyMapper.from((Object)source.getSessionIdleTimeout()).to(target::setSessionIdleTimeout);
        propertyMapper.from((Object)source.getAutoComplete()).to(target::setAutoComplete);
        propertyMapper.from((Object)source.getPrefetchCount()).to(target::setPrefetchCount);
        propertyMapper.from((Object)source.getSubQueue()).to(target::setSubQueue);
        propertyMapper.from((Object)source.getReceiveMode()).to(target::setReceiveMode);
        propertyMapper.from((Object)source.getSubscriptionName()).to(target::setSubscriptionName);
        propertyMapper.from((Object)source.getMaxAutoLockRenewDuration()).to(target::setMaxAutoLockRenewDuration);
    }
}

