/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.servicebus.core;

import com.azure.core.credential.TokenCredential;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusSessionReceiverClient;
import com.azure.messaging.servicebus.models.ServiceBusReceiveMode;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.service.implementation.servicebus.factory.ServiceBusSessionReceiverClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.servicebus.properties.ServiceBusReceiverClientProperties;
import com.azure.spring.cloud.service.servicebus.properties.ServiceBusEntityType;
import com.azure.spring.messaging.ConsumerIdentifier;
import com.azure.spring.messaging.PropertiesSupplier;
import com.azure.spring.messaging.servicebus.core.ServiceBusConsumerFactory;
import com.azure.spring.messaging.servicebus.core.properties.ConsumerProperties;
import com.azure.spring.messaging.servicebus.core.properties.NamespaceProperties;
import com.azure.spring.messaging.servicebus.implementation.properties.merger.ConsumerPropertiesParentMerger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.Nullable;

public final class DefaultServiceBusNamespaceConsumerFactory
implements ServiceBusConsumerFactory,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceBusNamespaceConsumerFactory.class);
    private final List<ServiceBusConsumerFactory.Listener> listeners = new ArrayList<ServiceBusConsumerFactory.Listener>();
    private final NamespaceProperties namespaceProperties;
    private final PropertiesSupplier<ConsumerIdentifier, ConsumerProperties> propertiesSupplier;
    private final Map<String, ServiceBusSessionReceiverClient> clients = new ConcurrentHashMap<String, ServiceBusSessionReceiverClient>();
    private final ConsumerPropertiesParentMerger parentMerger = new ConsumerPropertiesParentMerger();
    private final List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder>> customizers = new ArrayList<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder>>();
    private final List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder>> sessionReceiverCustomizers = new ArrayList<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder>>();
    private final Map<String, List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder>>> dedicatedSessionReceiverCustomizers = new HashMap<String, List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder>>>();
    private AzureCredentialResolver<TokenCredential> tokenCredentialResolver = null;
    private TokenCredential defaultCredential = null;

    public DefaultServiceBusNamespaceConsumerFactory(NamespaceProperties namespaceProperties) {
        this(namespaceProperties, (PropertiesSupplier<ConsumerIdentifier, ConsumerProperties>)((PropertiesSupplier)key -> null));
    }

    public DefaultServiceBusNamespaceConsumerFactory(NamespaceProperties namespaceProperties, PropertiesSupplier<ConsumerIdentifier, ConsumerProperties> supplier) {
        this.namespaceProperties = namespaceProperties;
        this.propertiesSupplier = supplier == null ? key -> null : supplier;
    }

    @Override
    public ServiceBusSessionReceiverClient createReceiver(String name) {
        return this.doCreateReceiver(name, null);
    }

    @Override
    public ServiceBusSessionReceiverClient createReceiver(String name, ServiceBusEntityType entityType) {
        ConsumerProperties consumerProperties;
        ConsumerProperties consumerProperties2 = consumerProperties = this.propertiesSupplier.getProperties((Object)new ConsumerIdentifier(name)) != null ? (ConsumerProperties)((Object)this.propertiesSupplier.getProperties((Object)new ConsumerIdentifier(name))) : new ConsumerProperties();
        if (entityType != null) {
            consumerProperties.setEntityType(entityType);
        }
        return this.doCreateReceiver(name, consumerProperties);
    }

    @Override
    public void addListener(ServiceBusConsumerFactory.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(ServiceBusConsumerFactory.Listener listener) {
        return this.listeners.remove(listener);
    }

    public void destroy() {
        this.clients.forEach((name, receiver) -> {
            this.listeners.forEach(l -> l.consumerRemoved((String)name, (ServiceBusSessionReceiverClient)receiver));
            receiver.close();
        });
        this.clients.clear();
        this.listeners.clear();
    }

    private ServiceBusSessionReceiverClient doCreateReceiver(String name, @Nullable ConsumerProperties properties) {
        return this.clients.computeIfAbsent(name, entityName -> {
            ServiceBusSessionReceiverClient receiverClient;
            ConsumerProperties consumerProperties = this.parentMerger.merge(properties, this.namespaceProperties);
            consumerProperties.setEntityName((String)entityName);
            if (Boolean.TRUE.equals(consumerProperties.getSessionEnabled())) {
                ServiceBusSessionReceiverClientBuilderFactory factory = new ServiceBusSessionReceiverClientBuilderFactory((ServiceBusReceiverClientProperties)consumerProperties, this.customizers);
                factory.setDefaultTokenCredential(this.defaultCredential);
                factory.setTokenCredentialResolver(this.tokenCredentialResolver);
                factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_INTEGRATION_SERVICE_BUS);
                ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder builder = (ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder)factory.build();
                this.customizeBuilder(name, builder);
                builder.receiveMode(ServiceBusReceiveMode.RECEIVE_AND_DELETE);
                builder.disableAutoComplete();
                LOGGER.debug("Set RECEIVE_AND_DELETE mode for request-reply-pattern receiver client, 'enableAutoComplete' is not needed in for RECEIVE_AND_DELETE mode.");
                receiverClient = builder.buildClient();
                this.listeners.forEach(l -> l.consumerAdded((String)entityName, receiverClient));
            } else {
                receiverClient = null;
                LOGGER.warn("Receiver client is null. Define a bean PropertiesSupplier<ConsumerIdentifier, ConsumerProperties> to enable consumer 'session-enabled'.");
            }
            return receiverClient;
        });
    }

    public void setTokenCredentialResolver(AzureCredentialResolver<TokenCredential> tokenCredentialResolver) {
        this.tokenCredentialResolver = tokenCredentialResolver;
    }

    public void setDefaultCredential(TokenCredential defaultCredential) {
        this.defaultCredential = defaultCredential;
    }

    public void addServiceBusClientBuilderCustomizer(AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder> customizer) {
        if (customizer == null) {
            LOGGER.debug("The provided '{}' customizer is null, will ignore it.", (Object)ServiceBusClientBuilder.class.getName());
        } else {
            this.customizers.add(customizer);
        }
    }

    public void addBuilderCustomizer(AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder> customizer) {
        if (customizer == null) {
            LOGGER.debug("The provided '{}' customizer is null, will ignore it.", (Object)ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder.class.getName());
            return;
        }
        this.sessionReceiverCustomizers.add(customizer);
    }

    public void addBuilderCustomizer(String entityName, AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder> customizer) {
        if (customizer == null) {
            LOGGER.debug("The provided '{}' dedicated customizer is null, will ignore it.", (Object)ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder.class.getName());
        } else {
            this.dedicatedSessionReceiverCustomizers.computeIfAbsent(entityName, key -> new ArrayList()).add(customizer);
        }
    }

    private void customizeBuilder(String entityName, ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder builder) {
        this.sessionReceiverCustomizers.forEach(customizer -> customizer.customize((Object)builder));
        ((List)this.dedicatedSessionReceiverCustomizers.getOrDefault(entityName, new ArrayList())).forEach(customizer -> customizer.customize((Object)builder));
    }
}

