/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.servicebus.core;

import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSessionReceiverClient;
import com.azure.spring.cloud.service.servicebus.properties.ServiceBusEntityType;
import com.azure.spring.messaging.converter.AzureMessageConverter;
import com.azure.spring.messaging.core.SendOperation;
import com.azure.spring.messaging.servicebus.core.ServiceBusConsumerFactory;
import com.azure.spring.messaging.servicebus.core.ServiceBusProducerFactory;
import com.azure.spring.messaging.servicebus.implementation.support.converter.ServiceBusMessageConverter;
import java.time.Duration;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class ServiceBusTemplate
implements SendOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBusTemplate.class);
    private static final ServiceBusMessageConverter DEFAULT_CONVERTER = new ServiceBusMessageConverter();
    private static final Duration DEFAULT_PRC_SEND_TIMEOUT = Duration.ofSeconds(30L);
    private final ServiceBusProducerFactory producerFactory;
    private final ServiceBusConsumerFactory consumerFactory;
    private AzureMessageConverter<ServiceBusReceivedMessage, ServiceBusMessage> messageConverter = DEFAULT_CONVERTER;
    private ServiceBusEntityType defaultEntityType;
    private Duration rpcSendTimeout = DEFAULT_PRC_SEND_TIMEOUT;

    public ServiceBusTemplate(@NonNull ServiceBusProducerFactory producerFactory) {
        this(producerFactory, null);
    }

    public ServiceBusTemplate(@NonNull ServiceBusProducerFactory producerFactory, ServiceBusConsumerFactory consumerFactory) {
        this.producerFactory = producerFactory;
        this.consumerFactory = consumerFactory;
    }

    public <U> Mono<Void> sendAsync(String destination, Message<U> message) {
        Assert.hasText((String)destination, (String)"destination can't be null or empty");
        ServiceBusSenderAsyncClient senderAsyncClient = this.producerFactory.createProducer(destination, this.defaultEntityType);
        ServiceBusMessage serviceBusMessage = (ServiceBusMessage)this.messageConverter.fromMessage(message, ServiceBusMessage.class);
        return senderAsyncClient.sendMessage(serviceBusMessage);
    }

    public <U> ServiceBusReceivedMessage sendAndReceive(String destination, Message<U> message) {
        return this.sendAndReceive(destination, this.defaultEntityType, message, this.rpcSendTimeout);
    }

    public <U> ServiceBusReceivedMessage sendAndReceive(String destination, ServiceBusEntityType entityType, Message<U> message) {
        return this.sendAndReceive(destination, entityType, message, this.rpcSendTimeout);
    }

    public <U> ServiceBusReceivedMessage sendAndReceive(String destination, ServiceBusEntityType entityType, Message<U> message, Duration sendTimeout) {
        Assert.hasText((String)destination, (String)"'destination' can't be null or empty");
        Assert.notNull((Object)this.consumerFactory, (String)"'consumerFactory' can't be null, please enable 'session-enabled' and 'rpc-enabled' for consumer.");
        ServiceBusEntityType currentEntityType = entityType;
        if (entityType == null && this.defaultEntityType != null) {
            currentEntityType = this.defaultEntityType;
        }
        MessageHeaders headers = message.getHeaders();
        String replyDestination = (String)headers.get((Object)"replyChannel", String.class);
        Assert.hasText((String)replyDestination, (String)"Message header 'replyChannel' can't be null or empty.");
        ServiceBusMessage serviceBusMessage = (ServiceBusMessage)this.messageConverter.fromMessage(message, ServiceBusMessage.class);
        String replyToSessionId = serviceBusMessage.getReplyToSessionId();
        if (!StringUtils.hasText((String)replyToSessionId)) {
            replyToSessionId = UUID.randomUUID().toString();
            serviceBusMessage.setReplyToSessionId(replyToSessionId);
            LOGGER.debug("Generated unique reply-to session-id '{}' for entity '{}'.", (Object)replyToSessionId, (Object)destination);
        } else {
            LOGGER.debug("Provided reply-to session id \u2018{}\u2019 for entity '{}', it should be unique.", (Object)replyToSessionId, (Object)destination);
        }
        ServiceBusSenderAsyncClient senderAsyncClient = this.producerFactory.createProducer(destination, this.defaultEntityType);
        senderAsyncClient.sendMessage(serviceBusMessage).block(sendTimeout);
        ServiceBusSessionReceiverClient sessionReceiver = this.consumerFactory.createReceiver(replyDestination, currentEntityType);
        Assert.notNull((Object)sessionReceiver, (String)"'sessionReceiver' can't be null, please enable 'session-enabled' for consumer.");
        return sessionReceiver.acceptSession(replyToSessionId).receiveMessages(1).stream().findFirst().orElse(null);
    }

    public void setMessageConverter(AzureMessageConverter<ServiceBusReceivedMessage, ServiceBusMessage> messageConverter) {
        this.messageConverter = messageConverter;
    }

    public AzureMessageConverter<ServiceBusReceivedMessage, ServiceBusMessage> getMessageConverter() {
        return this.messageConverter;
    }

    public void setDefaultEntityType(ServiceBusEntityType entityType) {
        this.defaultEntityType = entityType;
    }

    public void setRpcSendTimeout(Duration rpcSendTimeout) {
        if (rpcSendTimeout != null) {
            this.rpcSendTimeout = rpcSendTimeout;
        }
    }
}

