/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.servicebus.implementation.properties.merger;

import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.implementation.util.AzurePropertiesUtils;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.core.PropertiesMerger;
import com.azure.spring.messaging.servicebus.core.properties.ConsumerProperties;
import com.azure.spring.messaging.servicebus.core.properties.NamespaceProperties;

public class ConsumerPropertiesParentMerger
implements PropertiesMerger<ConsumerProperties, NamespaceProperties> {
    public ConsumerProperties merge(ConsumerProperties child, NamespaceProperties parent) {
        ConsumerProperties properties = new ConsumerProperties();
        if (child == null && parent == null) {
            return properties;
        }
        if (child == null) {
            child = new ConsumerProperties();
        }
        if (parent == null) {
            parent = new NamespaceProperties();
        }
        PropertyMapper propertyMapper = new PropertyMapper();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)parent, (AzureProperties)child, (AzureProperties)properties);
        propertyMapper.from((Object)parent.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)parent.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)parent.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)parent.getEntityName()).to(properties::setEntityName);
        propertyMapper.from((Object)parent.getEntityType()).to(properties::setEntityType);
        propertyMapper.from((Object)parent.getCustomEndpointAddress()).to(properties::setCustomEndpointAddress);
        ConsumerPropertiesParentMerger.copyConsumerPropertiesIfNotNull(child, properties);
        return properties;
    }

    public static void copyConsumerPropertiesIfNotNull(ConsumerProperties source, ConsumerProperties target) {
        PropertyMapper propertyMapper = new PropertyMapper();
        propertyMapper.from((Object)source.getDomainName()).to(target::setDomainName);
        propertyMapper.from((Object)source.getNamespace()).to(target::setNamespace);
        propertyMapper.from((Object)source.getConnectionString()).to(target::setConnectionString);
        propertyMapper.from((Object)source.getEntityName()).to(target::setEntityName);
        propertyMapper.from((Object)source.getEntityType()).to(target::setEntityType);
        propertyMapper.from((Object)source.getCustomEndpointAddress()).to(target::setCustomEndpointAddress);
        propertyMapper.from((Object)source.getSessionEnabled()).to(target::setSessionEnabled);
        propertyMapper.from((Object)source.getAutoComplete()).to(target::setAutoComplete);
        propertyMapper.from((Object)source.getPrefetchCount()).to(target::setPrefetchCount);
        propertyMapper.from((Object)source.getSubQueue()).to(target::setSubQueue);
        propertyMapper.from((Object)source.getReceiveMode()).to(target::setReceiveMode);
        propertyMapper.from((Object)source.getSubscriptionName()).to(target::setSubscriptionName);
        propertyMapper.from((Object)source.getMaxAutoLockRenewDuration()).to(target::setMaxAutoLockRenewDuration);
    }
}

