/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.storage.queue.core;

import com.azure.spring.core.util.Memoizer;
import com.azure.spring.storage.queue.core.StorageQueueClientFactory;
import com.azure.storage.queue.QueueAsyncClient;
import com.azure.storage.queue.QueueServiceAsyncClient;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class DefaultStorageQueueClientFactory
implements StorageQueueClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStorageQueueClientFactory.class);
    private final Function<String, QueueAsyncClient> queueClientCreator = Memoizer.memoize(this::createQueueClient);
    private final QueueServiceAsyncClient queueServiceAsyncClient;

    public DefaultStorageQueueClientFactory(@NonNull QueueServiceAsyncClient queueServiceAsyncClient) {
        this.queueServiceAsyncClient = queueServiceAsyncClient;
    }

    @Override
    public QueueAsyncClient getOrCreateQueueClient(String queueName) {
        return this.queueClientCreator.apply(queueName);
    }

    private QueueAsyncClient createQueueClient(String queueName) {
        QueueAsyncClient queueClient = this.queueServiceAsyncClient.getQueueAsyncClient(queueName);
        queueClient.create().subscribe(response -> {}, e -> LOGGER.error("Fail to create the queue.", e), () -> LOGGER.info("Complete creating the queue!"));
        return queueClient;
    }
}

