/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging;

import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ConsumerIdentifier {
    private final String destination;
    private final String group;

    public ConsumerIdentifier(String destination) {
        this(destination, null);
    }

    public ConsumerIdentifier(String destination, String group) {
        Assert.notNull((Object)destination, (String)"Destination must not be null!");
        this.destination = destination;
        this.group = group;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ConsumerIdentifier)) {
            return false;
        }
        ConsumerIdentifier consumerIdentifier = (ConsumerIdentifier)obj;
        return ObjectUtils.nullSafeEquals((Object)this.destination, (Object)consumerIdentifier.destination) && ObjectUtils.nullSafeEquals((Object)this.group, (Object)consumerIdentifier.group);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.destination);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.group);
        return result;
    }
}

