/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.converter;

import com.azure.spring.messaging.converter.AzureMessageConverter;
import com.azure.spring.messaging.converter.ConversionException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public abstract class AbstractAzureMessageConverter<I, O>
implements AzureMessageConverter<I, O> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAzureMessageConverter.class);
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    protected abstract ObjectMapper getObjectMapper();

    protected byte[] toPayload(Object object) {
        try {
            return this.getObjectMapper().writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new ConversionException("Failed to write JSON: " + object, e);
        }
    }

    protected <U> U fromPayload(Object payload, Class<U> payloadType) {
        try {
            return (U)this.getObjectMapper().readerFor(payloadType).readValue((byte[])payload);
        }
        catch (IOException e) {
            throw new ConversionException("Failed to read JSON: " + Arrays.toString((byte[])payload), e);
        }
    }

    @Override
    public O fromMessage(@NonNull Message<?> message, @NonNull Class<O> targetClass) {
        O azureMessage = this.internalFromMessage(message, targetClass);
        this.setCustomHeaders(message.getHeaders(), azureMessage);
        return azureMessage;
    }

    @Override
    public <U> Message<U> toMessage(@NonNull I azureMessage, Map<String, Object> headers, @NonNull Class<U> targetPayloadClass) {
        HashMap<String, Object> mergedHeaders = new HashMap<String, Object>();
        mergedHeaders.putAll(this.buildCustomHeaders(azureMessage));
        mergedHeaders.putAll(headers);
        return this.internalToMessage(azureMessage, mergedHeaders, targetPayloadClass);
    }

    protected abstract Object getPayload(I var1);

    protected abstract O fromString(String var1);

    protected abstract O fromByte(byte[] var1);

    protected void setCustomHeaders(MessageHeaders headers, O azureMessage) {
    }

    protected Map<String, Object> buildCustomHeaders(I azureMessage) {
        return this.emptyHeaders();
    }

    private Map<String, Object> emptyHeaders() {
        return new HashMap<String, Object>();
    }

    private O internalFromMessage(Message<?> message, Class<O> targetClass) {
        Object payload = message.getPayload();
        if (targetClass.isInstance(payload)) {
            return targetClass.cast(payload);
        }
        if (payload instanceof String) {
            return this.fromString((String)payload);
        }
        if (payload instanceof byte[]) {
            return this.fromByte((byte[])payload);
        }
        return this.fromByte(this.toPayload(payload));
    }

    protected <U> Message<?> internalToMessage(I azureMessage, Map<String, Object> headers, Class<U> targetPayloadClass) {
        Object payload = this.getPayload(azureMessage);
        Assert.isTrue((payload != null ? 1 : 0) != 0, (String)"payload must not be null");
        if (targetPayloadClass.isInstance(azureMessage)) {
            return MessageBuilder.withPayload(azureMessage).copyHeaders(headers).build();
        }
        if (targetPayloadClass == String.class) {
            return MessageBuilder.withPayload((Object)new String((byte[])payload, StandardCharsets.UTF_8)).copyHeaders(headers).build();
        }
        if (targetPayloadClass == byte[].class) {
            return MessageBuilder.withPayload((Object)payload).copyHeaders(headers).build();
        }
        return MessageBuilder.withPayload(this.fromPayload(payload, targetPayloadClass)).copyHeaders(headers).build();
    }
}

