/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.listener;

import com.azure.spring.messaging.listener.MessageListenerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;

public abstract class AbstractMessageListenerContainer
implements MessageListenerContainer,
BeanNameAware {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMessageListenerContainer.class);
    protected final Object lifecycleMonitor = new Object();
    private boolean active;
    private volatile boolean running = false;
    private String beanName;

    protected abstract void doStart();

    protected abstract void doStop();

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LOG.debug("Starting container with name {}", (Object)this.getBeanName());
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = true;
            this.lifecycleMonitor.notifyAll();
        }
        this.doStart();
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOG.debug("Stopping container with name {}", (Object)this.getBeanName());
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = false;
            this.lifecycleMonitor.notifyAll();
        }
        this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public int getPhase() {
        return 0;
    }

    public boolean isActive() {
        return this.active;
    }
}

