/*
 * Decompiled with CFR 0.152.
 */
package com.azure.sdk.build.tool;

import com.azure.sdk.build.tool.mojo.AzureSdkMojo;
import com.azure.sdk.build.tool.util.AnnotationUtils;
import com.azure.sdk.build.tool.util.MojoUtils;
import com.azure.sdk.build.tool.util.logging.Logger;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;

public class AnnotationProcessingTool
implements Runnable {
    private static Logger LOGGER = Logger.getInstance();

    @Override
    public void run() {
        LOGGER.info("Running Annotation Processing Tool");
        TreeSet<String> interestedPackages = new TreeSet<String>(Comparator.comparingInt(String::length));
        MojoUtils.getCompileSourceRoots().forEach(root -> AnnotationProcessingTool.buildPackageList(root, root, interestedPackages));
        ClassLoader classLoader = AnnotationUtils.getCompleteClassLoader(AnnotationProcessingTool.getAllPaths());
        AnnotationUtils.getAnnotation("com.azure.core.annotation.ServiceMethod", classLoader).map(a -> AnnotationUtils.findCallsToAnnotatedMethod(a, AnnotationProcessingTool.getAllPaths(), interestedPackages, true)).ifPresent(AzureSdkMojo.MOJO.getReport()::setServiceMethodCalls);
        Optional<Set> annotatedMethodCallerResults = AnnotationUtils.getAnnotation("com.azure.cosmos.util.Beta", classLoader).map(a -> AnnotationUtils.findCallsToAnnotatedMethod(a, AnnotationProcessingTool.getAllPaths(), interestedPackages, true));
        if (annotatedMethodCallerResults.isPresent()) {
            Set betaMethodCallers = annotatedMethodCallerResults.get();
            AzureSdkMojo.MOJO.getReport().setBetaMethodCalls(betaMethodCallers);
            if (!betaMethodCallers.isEmpty()) {
                StringBuilder message = new StringBuilder();
                message.append(MojoUtils.getString("betaApiUsed")).append(System.lineSeparator());
                betaMethodCallers.forEach(method -> message.append("   - ").append(method.toString()).append(System.lineSeparator()));
                MojoUtils.failOrWarn(() -> AzureSdkMojo.MOJO.isValidateNoBetaApiUsed(), message.toString());
            }
        }
    }

    private static Stream<Path> getAllPaths() {
        File targetDir = new File(AzureSdkMojo.MOJO.getProject().getBuild().getDirectory() + "/classes/");
        return Stream.concat(Stream.of(targetDir.getAbsolutePath()), MojoUtils.getAllDependencies().stream().map(a -> a.getFile().getAbsolutePath())).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    private static void buildPackageList(String rootDir, String currentDir, Set<String> packages) {
        File directory = new File(currentDir);
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isFile()) {
                String path = file.getPath();
                String packageName = path.substring(rootDir.length() + 1, path.lastIndexOf(File.separator));
                packages.add(packageName.replace(File.separatorChar, '.'));
                continue;
            }
            if (!file.isDirectory()) continue;
            AnnotationProcessingTool.buildPackageList(rootDir, file.getAbsolutePath(), packages);
        }
    }
}

