/*
 * Decompiled with CFR 0.152.
 */
package com.azure.sdk.build.tool;

import com.azure.sdk.build.tool.AzureDependencyMapping;
import com.azure.sdk.build.tool.models.OutdatedDependency;
import com.azure.sdk.build.tool.mojo.AzureSdkMojo;
import com.azure.sdk.build.tool.util.MavenUtils;
import com.azure.sdk.build.tool.util.MojoUtils;
import com.azure.sdk.build.tool.util.logging.Logger;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.InputLocation;

public class DependencyCheckerTool
implements Runnable {
    private static Logger LOGGER = Logger.getInstance();
    private static final String AZURE_SDK_BOM_ARTIFACT_ID = "azure-sdk-bom";
    private static final String COM_MICROSOFT_AZURE_GROUP_ID = "com.microsoft.azure";

    @Override
    public void run() {
        LOGGER.info("Running Dependency Checker Tool");
        this.checkForBom();
        this.checkForAzureSdkTrackOneDependencies();
    }

    private void checkForBom() {
        DependencyManagement depMgmt = AzureSdkMojo.MOJO.getProject().getDependencyManagement();
        DependencyManagement originalDepMgmt = AzureSdkMojo.MOJO.getProject().getOriginalModel().getDependencyManagement();
        Optional<Object> bomDependency = Optional.empty();
        Optional<Object> originalBomDependency = Optional.empty();
        if (depMgmt != null) {
            bomDependency = depMgmt.getDependencies().stream().filter(d -> d.getArtifactId().equals(AZURE_SDK_BOM_ARTIFACT_ID)).findAny();
        }
        if (originalDepMgmt != null) {
            originalBomDependency = originalDepMgmt.getDependencies().stream().filter(d -> d.getArtifactId().equals(AZURE_SDK_BOM_ARTIFACT_ID)).findAny();
        }
        Optional<Object> optional = bomDependency = bomDependency.isPresent() ? bomDependency : originalBomDependency;
        if (bomDependency.isPresent()) {
            String latestAvailableBomVersion = MavenUtils.getLatestArtifactVersion("com.azure", AZURE_SDK_BOM_ARTIFACT_ID);
            boolean isLatestBomVersion = ((Dependency)bomDependency.get()).getVersion().equals(latestAvailableBomVersion);
            if (!isLatestBomVersion) {
                MojoUtils.failOrWarn(AzureSdkMojo.MOJO::isValidateAzureSdkBomUsed, MojoUtils.getString("outdatedBomDependency"));
            }
            this.checkForAzureSdkDependencyVersions();
        } else {
            MojoUtils.failOrWarn(AzureSdkMojo.MOJO::isValidateAzureSdkBomUsed, MojoUtils.getString("missingBomDependency"));
        }
    }

    private void checkForAzureSdkDependencyVersions() {
        List dependencies = AzureSdkMojo.MOJO.getProject().getDependencies();
        List<Dependency> dependenciesWithOverriddenVersions = dependencies.stream().filter(dependency -> dependency.getGroupId().equals("com.azure")).filter(dependency -> {
            InputLocation location = dependency.getLocation((Object)"version");
            return !location.getSource().getModelId().startsWith("com.azure:azure-sdk-bom");
        }).collect(Collectors.toList());
        dependenciesWithOverriddenVersions.forEach(dependency -> MojoUtils.failOrWarn(AzureSdkMojo.MOJO::isValidateBomVersionsAreUsed, dependency.getArtifactId() + " " + MojoUtils.getString("overrideBomVersion")));
        List<Dependency> betaDependencies = dependencies.stream().filter(dependency -> dependency.getGroupId().equals("com.azure")).filter(dependency -> dependency.getVersion().contains("-beta")).collect(Collectors.toList());
        betaDependencies.forEach(dependency -> MojoUtils.failOrWarn(AzureSdkMojo.MOJO::isValidateNoBetaLibraryUsed, dependency.getArtifactId() + " " + MojoUtils.getString("betaDependencyUsed")));
    }

    private void checkForAzureSdkTrackOneDependencies() {
        String message;
        Set<OutdatedDependency> outdatedDirectDependencies = MojoUtils.getDirectDependencies().stream().filter(a -> COM_MICROSOFT_AZURE_GROUP_ID.equals(a.getGroupId())).map(AzureDependencyMapping::lookupReplacement).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        Set<OutdatedDependency> outdatedTransitiveDependencies = MojoUtils.getAllDependencies().stream().filter(d -> COM_MICROSOFT_AZURE_GROUP_ID.equals(d.getGroupId())).map(AzureDependencyMapping::lookupReplacement).filter(Optional::isPresent).map(Optional::get).filter(d -> !outdatedDirectDependencies.contains(d)).collect(Collectors.toSet());
        AzureSdkMojo.MOJO.getReport().setOutdatedDirectDependencies(outdatedDirectDependencies);
        AzureSdkMojo.MOJO.getReport().setOutdatedTransitiveDependencies(outdatedTransitiveDependencies);
        if (!outdatedDirectDependencies.isEmpty()) {
            message = MojoUtils.getString("deprecatedDirectDependency");
            for (OutdatedDependency outdatedDependency : outdatedDirectDependencies) {
                message = message + "\n    - " + outdatedDependency.getGav() + " --> " + outdatedDependency.getSuggestedReplacementGav();
            }
            MojoUtils.failOrWarn(AzureSdkMojo.MOJO::isValidateNoDeprecatedMicrosoftLibraryUsed, message);
        }
        if (!outdatedTransitiveDependencies.isEmpty()) {
            message = MojoUtils.getString("deprecatedIndirectDependency");
            for (OutdatedDependency outdatedDependency : outdatedDirectDependencies) {
                message = message + "\n    - " + outdatedDependency.getGav();
            }
            MojoUtils.failOrWarn(AzureSdkMojo.MOJO::isValidateNoDeprecatedMicrosoftLibraryUsed, message);
        }
    }
}

