/*
 * Decompiled with CFR 0.152.
 */
package com.azure.sdk.build.tool;

import com.azure.sdk.build.tool.models.BuildReport;
import com.azure.sdk.build.tool.mojo.AzureSdkMojo;
import com.azure.sdk.build.tool.util.AnnotatedMethodCallerResult;
import com.azure.sdk.build.tool.util.MavenUtils;
import com.azure.sdk.build.tool.util.MojoUtils;
import com.azure.sdk.build.tool.util.logging.Logger;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;

public class ReportGenerator {
    private static final Logger LOGGER = Logger.getInstance();
    private static final String AZURE_DEPENDENCY_GROUP = "com.azure";
    private static final String AZURE_SDK_BOM_ARTIFACT_ID = "azure-sdk-bom";
    private final BuildReport report;

    public ReportGenerator(BuildReport report) {
        this.report = report;
    }

    public void generateReport() {
        if (!this.report.getWarningMessages().isEmpty() && LOGGER.isWarnEnabled()) {
            this.report.getWarningMessages().forEach(LOGGER::warn);
        }
        if (!this.report.getErrorMessages().isEmpty() && LOGGER.isErrorEnabled()) {
            this.report.getErrorMessages().forEach(LOGGER::error);
        }
        this.report.setBomVersion(this.computeBomVersion());
        this.report.setAzureDependencies(this.computeAzureDependencies());
        this.createJsonReport();
        if (!this.report.getFailureMessages().isEmpty()) {
            StringBuilder sb = new StringBuilder("Build failure for the following reasons:\n");
            this.report.getFailureMessages().forEach(s -> sb.append(" - " + s + "\n"));
            throw new RuntimeException(sb.toString());
        }
    }

    private String computeBomVersion() {
        DependencyManagement depMgmt = AzureSdkMojo.MOJO.getProject().getDependencyManagement();
        Optional<Object> bomDependency = Optional.empty();
        if (depMgmt != null) {
            bomDependency = depMgmt.getDependencies().stream().filter(d -> d.getArtifactId().equals(AZURE_SDK_BOM_ARTIFACT_ID)).findAny();
        }
        if (bomDependency.isPresent()) {
            return ((Dependency)bomDependency.get()).getVersion();
        }
        return null;
    }

    private void createJsonReport() {
        block14: {
            try {
                StringWriter writer = new StringWriter();
                JsonGenerator generator = new JsonFactory().createGenerator((Writer)writer).useDefaultPrettyPrinter();
                generator.writeStartObject();
                generator.writeStringField("group", AzureSdkMojo.MOJO.getProject().getGroupId());
                generator.writeStringField("artifact", AzureSdkMojo.MOJO.getProject().getArtifactId());
                generator.writeStringField("version", AzureSdkMojo.MOJO.getProject().getVersion());
                generator.writeStringField("name", AzureSdkMojo.MOJO.getProject().getName());
                if (this.report.getBomVersion() != null && !this.report.getBomVersion().isEmpty()) {
                    generator.writeStringField("bomVersion", this.report.getBomVersion());
                }
                if (this.report.getAzureDependencies() != null && !this.report.getAzureDependencies().isEmpty()) {
                    this.writeArray("azureDependencies", this.report.getAzureDependencies(), generator);
                }
                if (this.report.getServiceMethodCalls() != null && !this.report.getServiceMethodCalls().isEmpty()) {
                    this.writeArray("serviceMethodCalls", this.report.getServiceMethodCalls().stream().map(AnnotatedMethodCallerResult::toString).collect(Collectors.toList()), generator);
                }
                if (this.report.getBetaMethodCalls() != null && !this.report.getBetaMethodCalls().isEmpty()) {
                    this.writeArray("betaMethodCalls", this.report.getBetaMethodCalls().stream().map(AnnotatedMethodCallerResult::toString).collect(Collectors.toList()), generator);
                }
                if (!this.report.getErrorMessages().isEmpty()) {
                    this.writeArray("errorMessages", this.report.getErrorMessages(), generator);
                }
                if (!this.report.getWarningMessages().isEmpty()) {
                    this.writeArray("warningMessages", this.report.getWarningMessages(), generator);
                }
                if (!this.report.getFailureMessages().isEmpty()) {
                    this.writeArray("failureMessages", this.report.getFailureMessages(), generator);
                }
                generator.writeEndObject();
                generator.close();
                writer.close();
                this.report.setJsonReport(writer.toString());
                String reportFileString = AzureSdkMojo.MOJO.getReportFile();
                if (reportFileString == null || reportFileString.isEmpty()) break block14;
                File reportFile = new File(reportFileString);
                try (FileWriter fileWriter = new FileWriter(reportFile);){
                    fileWriter.write(this.report.getJsonReport());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeArray(String fieldName, Collection<String> values, JsonGenerator generator) throws IOException {
        generator.writeFieldName(fieldName);
        generator.writeStartArray();
        for (String value : values) {
            generator.writeString(value);
        }
        generator.writeEndArray();
    }

    private List<String> computeAzureDependencies() {
        return MojoUtils.getAllDependencies().stream().filter(artifact -> artifact.getGroupId().startsWith(AZURE_DEPENDENCY_GROUP)).map(MavenUtils::toGAV).collect(Collectors.toList());
    }
}

