/*
 * Decompiled with CFR 0.152.
 */
package com.azure.sdk.build.tool.mojo;

import com.azure.monitor.opentelemetry.exporter.AzureMonitorExporterBuilder;
import com.azure.monitor.opentelemetry.exporter.AzureMonitorTraceExporter;
import com.azure.sdk.build.tool.ReportGenerator;
import com.azure.sdk.build.tool.Tools;
import com.azure.sdk.build.tool.models.BuildReport;
import com.azure.sdk.build.tool.models.PingSpanData;
import com.azure.sdk.build.tool.util.logging.Logger;
import edu.emory.mathcs.backport.java.util.Collections;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="run", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyCollection=ResolutionScope.RUNTIME, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class AzureSdkMojo
extends AbstractMojo {
    public static AzureSdkMojo MOJO;
    private static final Logger LOGGER;
    private static final String APP_INSIGHTS_CONNECTION_STRING = "InstrumentationKey=bccfcc21-ff29-4316-9d65-dc40e7934e59;IngestionEndpoint=https://westus2-2.in.applicationinsights.azure.com/";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="validateAzureSdkBomUsed", defaultValue="true")
    private boolean validateAzureSdkBomUsed;
    @Parameter(property="validateNoDeprecatedMicrosoftLibraryUsed", defaultValue="true")
    private boolean validateNoDeprecatedMicrosoftLibraryUsed;
    @Parameter(property="validateBomVersionsAreUsed", defaultValue="true")
    private boolean validateBomVersionsAreUsed;
    @Parameter(property="validateNoBetaLibraryUsed", defaultValue="true")
    private boolean validateNoBetaLibraryUsed;
    @Parameter(property="validateNoBetaApiUsed", defaultValue="true")
    private boolean validateNoBetaApiUsed;
    @Parameter(property="reportFile", defaultValue="")
    private String reportFile;
    @Parameter(property="sendToMicrosoft", defaultValue="true")
    private boolean sendToMicrosoft;
    private final BuildReport buildReport;

    public AzureSdkMojo() {
        MOJO = this;
        this.buildReport = new BuildReport();
    }

    public BuildReport getReport() {
        return this.buildReport;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"========================================================================");
        this.getLog().info((CharSequence)"= Running the Azure SDK Maven Build Tool                               =");
        this.getLog().info((CharSequence)"========================================================================");
        if (this.sendToMicrosoft) {
            this.pingAppInsights();
        }
        Tools.getTools().forEach(Runnable::run);
        ReportGenerator reportGenerator = new ReportGenerator(this.buildReport);
        reportGenerator.generateReport();
    }

    private void pingAppInsights() {
        block5: {
            try {
                LOGGER.info("Sending ping message to Application Insights");
                AzureMonitorTraceExporter azureMonitorExporter = new AzureMonitorExporterBuilder().connectionString(APP_INSIGHTS_CONNECTION_STRING).buildTraceExporter();
                PingSpanData pingSpanData = new PingSpanData();
                CompletableResultCode completionCode = azureMonitorExporter.export((Collection)Collections.singletonList((Object)pingSpanData)).join(30L, TimeUnit.SECONDS);
                if (completionCode.isSuccess()) {
                    LOGGER.info("Successfully sent ping message to Application Insights");
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Failed to send ping message to Application Insights");
                }
            }
            catch (Exception ex) {
                if (!LOGGER.isWarnEnabled()) break block5;
                LOGGER.warn("Unable to send ping message to Application Insights. " + ex.getMessage());
            }
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isValidateAzureSdkBomUsed() {
        return this.validateAzureSdkBomUsed;
    }

    public boolean isValidateNoDeprecatedMicrosoftLibraryUsed() {
        return this.validateNoDeprecatedMicrosoftLibraryUsed;
    }

    public boolean isValidateBomVersionsAreUsed() {
        return this.validateBomVersionsAreUsed;
    }

    public boolean isValidateNoBetaLibraryUsed() {
        return this.validateNoBetaLibraryUsed;
    }

    public boolean isValidateNoBetaApiUsed() {
        return this.validateNoBetaApiUsed;
    }

    public String getReportFile() {
        return this.reportFile;
    }

    static {
        LOGGER = Logger.getInstance();
    }
}

