/*
 * Decompiled with CFR 0.152.
 */
package com.azure.sdk.build.tool.util;

import com.azure.sdk.build.tool.util.AnnotatedMethodCallerResult;
import com.azure.sdk.build.tool.util.logging.Logger;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reflections8.Configuration;
import org.reflections8.Reflections;
import org.reflections8.ReflectionsException;
import org.reflections8.scanners.MemberUsageScanner;
import org.reflections8.scanners.MethodAnnotationsScanner;
import org.reflections8.scanners.Scanner;
import org.reflections8.util.ClasspathHelper;
import org.reflections8.util.ConfigurationBuilder;

public final class AnnotationUtils {
    private static Logger LOGGER = Logger.getInstance();

    private AnnotationUtils() {
    }

    public static ClassLoader getCompleteClassLoader(Stream<Path> paths) {
        List<URL> urls = paths.map(AnnotationUtils::pathToUrl).collect(Collectors.toList());
        return URLClassLoader.newInstance(urls.toArray(new URL[0]));
    }

    public static Optional<Class<? extends Annotation>> getAnnotation(String name, ClassLoader classLoader) {
        try {
            return Optional.of(Class.forName(name, false, classLoader).asSubclass(Annotation.class));
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("Unable to find annotation " + name + " in classpath");
            return Optional.empty();
        }
    }

    public static Set<AnnotatedMethodCallerResult> findCallsToAnnotatedMethod(Class<? extends Annotation> annotation, Stream<Path> paths, Set<String> interestedPackages, boolean recursive) {
        ConfigurationBuilder config;
        block3: {
            config = new ConfigurationBuilder().setScanners(new Scanner[]{new MethodAnnotationsScanner(), new MemberUsageScanner()});
            List<URL> urls = paths.map(AnnotationUtils::pathToUrl).collect(Collectors.toList());
            config.addUrls(urls);
            config.addClassLoader((ClassLoader)URLClassLoader.newInstance(urls.toArray(new URL[0])));
            URLClassLoader contextClassLoader = (URLClassLoader)ClasspathHelper.contextClassLoader();
            try {
                Method method2 = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method2.setAccessible(true);
                for (URL url : urls) {
                    method2.invoke((Object)contextClassLoader, url);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block3;
                LOGGER.error("Unable to reflectively call addURL method on URL class. " + e.getMessage());
            }
        }
        Reflections reflections = new Reflections((Configuration)config);
        Set annotatedMethods = reflections.getMethodsAnnotatedWith(annotation);
        HashSet<AnnotatedMethodCallerResult> results = new HashSet<AnnotatedMethodCallerResult>();
        annotatedMethods.forEach(method -> AnnotationUtils.checkMethod(reflections, annotation, method, interestedPackages, recursive, results));
        return results;
    }

    private static void checkMethod(Reflections reflections, Class<? extends Annotation> annotation, Method method, Set<String> interestedPackages, boolean recursive, Set<AnnotatedMethodCallerResult> results) {
        Set callingMethods;
        try {
            callingMethods = reflections.getMethodUsage(method);
        }
        catch (ReflectionsException e) {
            LOGGER.info("Unable to get method usage for method " + method.getName() + ". " + e.getMessage());
            return;
        }
        callingMethods.forEach(member -> {
            if (member instanceof Method) {
                Method methodMember = (Method)member;
                String packageName = methodMember.getDeclaringClass().getPackage().getName();
                if (interestedPackages.contains(packageName)) {
                    results.add(new AnnotatedMethodCallerResult(annotation, method, (Member)member));
                } else if (recursive && !methodMember.equals(method)) {
                    AnnotationUtils.checkMethod(reflections, annotation, methodMember, interestedPackages, recursive, results);
                }
            }
        });
    }

    private static URL pathToUrl(Path path) {
        try {
            URL url = path.toUri().toURL();
            return url;
        }
        catch (MalformedURLException e) {
            LOGGER.info("Path " + path + " cannot be converted to URL. " + e.getMessage());
            return null;
        }
    }
}

