/*
 * Decompiled with CFR 0.152.
 */
package com.azure.sdk.build.tool.util;

import com.azure.sdk.build.tool.util.logging.Logger;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.artifact.Artifact;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenUtils {
    private static final Logger LOGGER = Logger.getInstance();

    public static String toGAV(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLatestArtifactVersion(String groupId, String artifactId) {
        HttpURLConnection connection = null;
        try {
            groupId = groupId.replace(".", "/");
            URL url = new URL("https://repo1.maven.org/maven2/" + groupId + "/" + artifactId + "/maven-metadata.xml");
            if (LOGGER.isVerboseEnabled()) {
                LOGGER.verbose(url.toString());
            }
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("accept", "application/xml");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int responseCode = connection.getResponseCode();
            if (200 == responseCode) {
                InputStream responseStream = connection.getInputStream();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(responseStream);
                NodeList versionsList = doc.getElementsByTagName("version");
                String latestVersion = null;
                for (int i = versionsList.getLength() - 1; i >= 0; --i) {
                    Node versionNode = versionsList.item(i);
                    if (versionNode.getTextContent().contains("beta")) continue;
                    latestVersion = versionNode.getTextContent();
                    break;
                }
                if (LOGGER.isVerboseEnabled()) {
                    LOGGER.verbose("The latest version of " + artifactId + " is " + latestVersion);
                }
                String string = latestVersion;
                return string;
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Got a non-successful response for  " + artifactId + ": " + responseCode);
            }
        }
        catch (Exception exception) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Got error getting latest maven dependency version. " + exception.getMessage());
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }
}

