/*
 * Decompiled with CFR 0.152.
 */
package com.azure.sdk.build.tool;

import com.azure.sdk.build.tool.models.OutdatedDependency;
import com.azure.sdk.build.tool.util.MavenUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;

public class AzureDependencyMapping {
    private static final String TRACK_ONE_GROUP_ID = "com.microsoft.azure";
    private static final String TRACK_TWO_GROUP_ID = "com.azure";
    private static final Map<String, List<String>> TRACK_ONE_REDIRECTS = new HashMap<String, List<String>>();

    public static Optional<OutdatedDependency> lookupReplacement(Artifact artifact) {
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        if (TRACK_ONE_GROUP_ID.equals(groupId)) {
            if (TRACK_ONE_REDIRECTS.containsKey(artifactId)) {
                List<String> newArtifactIds = TRACK_ONE_REDIRECTS.get(artifactId);
                List<String> newGavs = newArtifactIds.stream().map(newArtifactId -> "com.azure:" + newArtifactId + ":" + MavenUtils.getLatestArtifactVersion(TRACK_TWO_GROUP_ID, newArtifactId)).collect(Collectors.toList());
                return Optional.of(new OutdatedDependency(MavenUtils.toGAV(artifact), newGavs));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    static {
        TRACK_ONE_REDIRECTS.put("azure-cosmosdb", Collections.singletonList("azure-cosmos"));
        TRACK_ONE_REDIRECTS.put("azure-keyvault", Arrays.asList("azure-security-keyvault-keys", "azure-security-keyvault-certificates", "azure-security-keyvault-secrets"));
        TRACK_ONE_REDIRECTS.put("azure-storage-blob", Collections.singletonList("azure-storage-blob"));
        TRACK_ONE_REDIRECTS.put("azure-eventhubs", Collections.singletonList("azure-messaging-eventhubs"));
        TRACK_ONE_REDIRECTS.put("azure-eventhubs-eph", Collections.singletonList("azure-messaging-eventhubs-checkpointstore-blob"));
        TRACK_ONE_REDIRECTS.put("azure-servicebus", Collections.singletonList("azure-messaging-servicebus"));
        TRACK_ONE_REDIRECTS.put("azure-eventgrid", Collections.singletonList("azure-messaging-eventgrid"));
        TRACK_ONE_REDIRECTS.put("azure-loganalytics", Collections.singletonList("azure-monitor-query"));
    }
}

