/*
 * Decompiled with CFR 0.152.
 */
package com.azure.sdk.build.tool;

import com.azure.sdk.build.tool.AzureDependencyMapping;
import com.azure.sdk.build.tool.models.BuildErrorCode;
import com.azure.sdk.build.tool.models.OutdatedDependency;
import com.azure.sdk.build.tool.mojo.AzureSdkMojo;
import com.azure.sdk.build.tool.util.MavenUtils;
import com.azure.sdk.build.tool.util.MojoUtils;
import com.azure.sdk.build.tool.util.logging.Logger;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.InputLocation;

public class DependencyCheckerTool
implements Runnable {
    private static final Logger LOGGER = Logger.getInstance();
    private static final String AZURE_SDK_BOM_ARTIFACT_ID = "azure-sdk-bom";
    private static final String COM_MICROSOFT_AZURE_GROUP_ID = "com.microsoft.azure";

    @Override
    public void run() {
        LOGGER.info("Running Dependency Checker Tool");
        this.checkForBom();
        this.checkForAzureSdkTrackOneDependencies();
    }

    private void checkForBom() {
        DependencyManagement depMgmt = AzureSdkMojo.getMojo().getProject().getDependencyManagement();
        DependencyManagement originalDepMgmt = AzureSdkMojo.getMojo().getProject().getOriginalModel().getDependencyManagement();
        Optional<Object> bomDependency = Optional.empty();
        Optional<Object> originalBomDependency = Optional.empty();
        if (depMgmt != null) {
            bomDependency = depMgmt.getDependencies().stream().filter(d -> d.getArtifactId().equals(AZURE_SDK_BOM_ARTIFACT_ID)).findAny();
        }
        if (originalDepMgmt != null) {
            originalBomDependency = originalDepMgmt.getDependencies().stream().filter(d -> d.getArtifactId().equals(AZURE_SDK_BOM_ARTIFACT_ID)).findAny();
        }
        Optional<Object> optional = bomDependency = bomDependency.isPresent() ? bomDependency : originalBomDependency;
        if (bomDependency.isPresent()) {
            boolean isLatestBomVersion;
            String latestAvailableBomVersion = MavenUtils.getLatestArtifactVersion("com.azure", AZURE_SDK_BOM_ARTIFACT_ID);
            String usedBomVersion = ((Dependency)bomDependency.get()).getVersion();
            if (usedBomVersion.startsWith("${")) {
                String propertyName = usedBomVersion.substring(2, usedBomVersion.indexOf("}"));
                AzureSdkMojo.getMojo().getLog().info((CharSequence)("BOM Version property name " + propertyName));
                usedBomVersion = AzureSdkMojo.getMojo().getProject().getProperties().getProperty(propertyName);
            }
            if (!(isLatestBomVersion = usedBomVersion.equals(latestAvailableBomVersion))) {
                MojoUtils.failOrWarn(AzureSdkMojo.getMojo()::isValidateLatestBomVersionUsed, BuildErrorCode.OUTDATED_DEPENDENCY, MojoUtils.getString("outdatedBomDependency") + " using version" + usedBomVersion + " latest version: " + latestAvailableBomVersion, Arrays.asList(MavenUtils.toGAV((Dependency)bomDependency.get())));
            }
            this.checkForAzureSdkDependencyVersions();
            AzureSdkMojo.getMojo().getReport().setBomVersion(usedBomVersion);
        } else {
            MojoUtils.failOrWarn(AzureSdkMojo.getMojo()::isValidateAzureSdkBomUsed, BuildErrorCode.BOM_NOT_USED, MojoUtils.getString("missingBomDependency"));
        }
    }

    private void checkForAzureSdkDependencyVersions() {
        List dependencies = AzureSdkMojo.getMojo().getProject().getDependencies();
        List<Dependency> dependenciesWithOverriddenVersions = dependencies.stream().filter(dependency -> dependency.getGroupId().equals("com.azure")).filter(dependency -> {
            InputLocation location = dependency.getLocation((Object)"version");
            return !location.getSource().getModelId().startsWith("com.azure:azure-sdk-bom");
        }).collect(Collectors.toList());
        dependenciesWithOverriddenVersions.forEach(dependency -> MojoUtils.failOrWarn(AzureSdkMojo.getMojo()::isValidateBomVersionsAreUsed, BuildErrorCode.BOM_VERSION_OVERRIDDEN, dependency.getArtifactId() + " " + MojoUtils.getString("overrideBomVersion"), Arrays.asList(MavenUtils.toGAV(dependency))));
        List<Dependency> betaDependencies = dependencies.stream().filter(dependency -> dependency.getGroupId().equals("com.azure")).filter(dependency -> dependency.getVersion().contains("-beta")).collect(Collectors.toList());
        betaDependencies.forEach(dependency -> MojoUtils.failOrWarn(AzureSdkMojo.getMojo()::isValidateNoBetaLibraryUsed, BuildErrorCode.BETA_DEPENDENCY_USED, dependency.getArtifactId() + " " + MojoUtils.getString("betaDependencyUsed"), Arrays.asList(MavenUtils.toGAV(dependency))));
    }

    private void checkForAzureSdkTrackOneDependencies() {
        StringBuilder message;
        List<OutdatedDependency> outdatedDirectDependencies = MojoUtils.getDirectDependencies().stream().filter(a -> COM_MICROSOFT_AZURE_GROUP_ID.equals(a.getGroupId())).map(AzureDependencyMapping::lookupReplacement).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        List<OutdatedDependency> outdatedTransitiveDependencies = MojoUtils.getAllDependencies().stream().filter(d -> COM_MICROSOFT_AZURE_GROUP_ID.equals(d.getGroupId())).map(AzureDependencyMapping::lookupReplacement).filter(Optional::isPresent).map(Optional::get).filter(d -> !outdatedDirectDependencies.contains(d)).collect(Collectors.toList());
        AzureSdkMojo.getMojo().getReport().setOutdatedDirectDependencies(outdatedDirectDependencies);
        AzureSdkMojo.getMojo().getReport().setOutdatedTransitiveDependencies(outdatedTransitiveDependencies);
        if (!outdatedDirectDependencies.isEmpty()) {
            message = new StringBuilder(MojoUtils.getString("deprecatedDirectDependency"));
            for (OutdatedDependency outdatedDependency : outdatedDirectDependencies) {
                message.append("\n    - ").append(outdatedDependency.getOutdatedDependency()).append(" --> ").append(outdatedDependency.getSuggestedReplacements());
            }
            List outdatedDependencyGavs = outdatedDirectDependencies.stream().map(OutdatedDependency::getOutdatedDependency).collect(Collectors.toList());
            MojoUtils.failOrWarn(AzureSdkMojo.getMojo()::isValidateNoDeprecatedMicrosoftLibraryUsed, BuildErrorCode.DEPRECATED_DEPENDENCY_USED, message.toString(), outdatedDependencyGavs);
        }
        if (!outdatedTransitiveDependencies.isEmpty()) {
            message = new StringBuilder(MojoUtils.getString("deprecatedIndirectDependency"));
            for (OutdatedDependency outdatedDependency : outdatedDirectDependencies) {
                message.append("\n    - ").append(outdatedDependency.getOutdatedDependency());
            }
            List<String> outdatedTransitiveDependencyGavs = outdatedTransitiveDependencies.stream().map(OutdatedDependency::getOutdatedDependency).collect(Collectors.toList());
            MojoUtils.failOrWarn(AzureSdkMojo.getMojo()::isValidateNoDeprecatedMicrosoftLibraryUsed, BuildErrorCode.DEPRECATED_TRANSITIVE_DEPENDENCY, message.toString(), outdatedTransitiveDependencyGavs);
        }
    }
}

