/*
 * Decompiled with CFR 0.152.
 */
package com.azure.sdk.build.tool;

import com.azure.core.util.BinaryData;
import com.azure.sdk.build.tool.models.BuildReport;
import com.azure.sdk.build.tool.mojo.AzureSdkMojo;
import com.azure.sdk.build.tool.util.MavenUtils;
import com.azure.sdk.build.tool.util.MojoUtils;
import com.azure.sdk.build.tool.util.logging.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.stream.Collectors;

public class ReportGenerator {
    private static final Logger LOGGER = Logger.getInstance();
    private static final String AZURE_DEPENDENCY_GROUP = "com.azure";
    private static final String AZURE_SDK_BOM_ARTIFACT_ID = "azure-sdk-bom";
    private final BuildReport report;

    public ReportGenerator(BuildReport report) {
        this.report = report;
    }

    public BuildReport getReport() {
        return this.report;
    }

    public void generateReport() {
        this.report.setAzureDependencies(this.computeAzureDependencies());
        this.report.setGroupId(this.getMd5(AzureSdkMojo.getMojo().getProject().getGroupId()));
        this.report.setArtifactId(this.getMd5(AzureSdkMojo.getMojo().getProject().getArtifactId()));
        this.report.setVersion(this.getMd5(AzureSdkMojo.getMojo().getProject().getVersion()));
        this.writeReportToFile();
    }

    private void writeReportToFile() {
        String reportFileString = AzureSdkMojo.getMojo().getReportFile();
        if (reportFileString != null && !reportFileString.isEmpty()) {
            File reportFile = new File(reportFileString);
            try (FileWriter fileWriter = new FileWriter(reportFile);){
                fileWriter.write(BinaryData.fromObject((Object)this.report).toString());
            }
            catch (IOException exception) {
                AzureSdkMojo.getMojo().getLog().warn((CharSequence)("Unable to write report to " + reportFileString), (Throwable)exception);
            }
        }
    }

    private List<String> computeAzureDependencies() {
        return MojoUtils.getAllDependencies().stream().filter(artifact -> artifact.getGroupId().startsWith(AZURE_DEPENDENCY_GROUP)).map(MavenUtils::toGAV).collect(Collectors.toList());
    }

    private String getMd5(String inputText) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(inputText.getBytes(StandardCharsets.UTF_8));
            return String.format("%032x", new BigInteger(1, digest));
        }
        catch (NoSuchAlgorithmException exception) {
            return "Unknown";
        }
    }
}

