/*
 * Decompiled with CFR 0.152.
 */
package com.azure.sdk.build.tool.mojo;

import com.azure.core.util.BinaryData;
import com.azure.sdk.build.tool.ReportGenerator;
import com.azure.sdk.build.tool.Tools;
import com.azure.sdk.build.tool.implementation.ApplicationInsightsClient;
import com.azure.sdk.build.tool.implementation.ApplicationInsightsClientBuilder;
import com.azure.sdk.build.tool.implementation.models.MonitorBase;
import com.azure.sdk.build.tool.implementation.models.TelemetryEventData;
import com.azure.sdk.build.tool.implementation.models.TelemetryItem;
import com.azure.sdk.build.tool.models.BuildError;
import com.azure.sdk.build.tool.models.BuildErrorLevel;
import com.azure.sdk.build.tool.models.BuildReport;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="run", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyCollection=ResolutionScope.RUNTIME, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class AzureSdkMojo
extends AbstractMojo {
    public static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private static AzureSdkMojo mojo;
    private static final ObjectMapper OBJECT_MAPPER;
    private static final String APP_INSIGHTS_INSTRUMENTATION_KEY = "1d377c0e-44f8-4d56-bee7-7f13a3fef594";
    private static final String APP_INSIGHTS_ENDPOINT = "https://centralus-2.in.applicationinsights.azure.com/";
    private static final String AZURE_SDK_BUILD_TOOL = "azure-sdk-build-tool";
    private final ApplicationInsightsClient applicationInsightsClient;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="validateAzureSdkBomUsed", defaultValue="true")
    private boolean validateAzureSdkBomUsed;
    @Parameter(property="validateNoDeprecatedMicrosoftLibraryUsed", defaultValue="true")
    private boolean validateNoDeprecatedMicrosoftLibraryUsed;
    @Parameter(property="validateBomVersionsAreUsed", defaultValue="true")
    private boolean validateBomVersionsAreUsed;
    @Parameter(property="validateNoBetaLibraryUsed", defaultValue="true")
    private boolean validateNoBetaLibraryUsed;
    @Parameter(property="validateNoBetaApiUsed", defaultValue="true")
    private boolean validateNoBetaApiUsed;
    @Parameter(property="validateLatestBomVersionUsed", defaultValue="true")
    private boolean validateLatestBomVersionUsed;
    @Parameter(property="reportFile", defaultValue="")
    private String reportFile;
    @Parameter(property="sendToMicrosoft", defaultValue="true")
    private boolean sendToMicrosoft;
    private final BuildReport buildReport;

    public AzureSdkMojo() {
        mojo = this;
        this.buildReport = new BuildReport();
        this.applicationInsightsClient = new ApplicationInsightsClientBuilder().host(APP_INSIGHTS_ENDPOINT).buildClient();
    }

    public static AzureSdkMojo getMojo() {
        return mojo;
    }

    public BuildReport getReport() {
        return this.buildReport;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"========================================================================");
        this.getLog().info((CharSequence)"= Running the Azure SDK Maven Build Tool                               =");
        this.getLog().info((CharSequence)"========================================================================");
        Tools.getTools().forEach(Runnable::run);
        ReportGenerator reportGenerator = new ReportGenerator(this.buildReport);
        reportGenerator.generateReport();
        BuildReport report = reportGenerator.getReport();
        if (this.sendToMicrosoft) {
            this.sendReportToAppInsights(report);
        }
        StringBuilder sb = new StringBuilder("Build failure for the following reasons:\n");
        boolean hasErrors = false;
        for (BuildError error : report.getErrors()) {
            if (BuildErrorLevel.WARNING.equals((Object)error.getLevel())) {
                this.getLog().warn((CharSequence)error.getMessage());
                continue;
            }
            if (!BuildErrorLevel.ERROR.equals((Object)error.getLevel())) continue;
            hasErrors = true;
            sb.append(" - " + error.getMessage() + "\n");
        }
        if (hasErrors) {
            throw new RuntimeException(sb.toString());
        }
    }

    private void sendReportToAppInsights(BuildReport report) {
        try {
            TelemetryItem telemetryItem = new TelemetryItem();
            telemetryItem.setTime(OffsetDateTime.now());
            telemetryItem.setName(AZURE_SDK_BUILD_TOOL);
            telemetryItem.setInstrumentationKey(APP_INSIGHTS_INSTRUMENTATION_KEY);
            TelemetryEventData data = new TelemetryEventData();
            Map<String, String> customEventProperties = this.getCustomEventProperties(report);
            data.setProperties(customEventProperties);
            MonitorBase monitorBase = new MonitorBase();
            monitorBase.setBaseData(data).setBaseType("EventData");
            data.setName("azure-sdk-java-build-telemetry");
            telemetryItem.setData(monitorBase);
            ArrayList<TelemetryItem> telemetryItems = new ArrayList<TelemetryItem>();
            telemetryItems.add(telemetryItem);
            this.applicationInsightsClient.trackAsync(telemetryItems).block();
        }
        catch (Exception ex) {
            this.getLog().warn((CharSequence)("Unable to send report to Application Insights. " + ex.getMessage()));
        }
    }

    private Map<String, String> getCustomEventProperties(BuildReport report) {
        Map properties = (Map)OBJECT_MAPPER.convertValue((Object)report, MAP_TYPE_REFERENCE);
        HashMap<String, String> customEventProperties = new HashMap<String, String>(properties.size());
        properties.forEach((key, value) -> {
            if (value instanceof String) {
                customEventProperties.put((String)key, (String)value);
            } else {
                customEventProperties.put((String)key, BinaryData.fromObject((Object)value).toString());
            }
        });
        return customEventProperties;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isValidateAzureSdkBomUsed() {
        return this.validateAzureSdkBomUsed;
    }

    public boolean isValidateNoDeprecatedMicrosoftLibraryUsed() {
        return this.validateNoDeprecatedMicrosoftLibraryUsed;
    }

    public boolean isValidateBomVersionsAreUsed() {
        return this.validateBomVersionsAreUsed;
    }

    public boolean isValidateNoBetaLibraryUsed() {
        return this.validateNoBetaLibraryUsed;
    }

    public boolean isValidateNoBetaApiUsed() {
        return this.validateNoBetaApiUsed;
    }

    public boolean isValidateLatestBomVersionUsed() {
        return this.validateLatestBomVersionUsed;
    }

    public String getReportFile() {
        return this.reportFile;
    }

    static {
        OBJECT_MAPPER = new ObjectMapper();
    }
}

