/*
 * Decompiled with CFR 0.152.
 */
package com.azure.sdk.build.tool.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Objects;

public class AnnotatedMethodCallerResult {
    private final Class<? extends Annotation> annotation;
    private final Method annotatedMethod;
    private final Member callingMember;

    public AnnotatedMethodCallerResult(Class<? extends Annotation> annotation, Method annotatedMethod, Member callingMember) {
        this.annotation = Objects.requireNonNull(annotation);
        this.annotatedMethod = Objects.requireNonNull(annotatedMethod);
        this.callingMember = Objects.requireNonNull(callingMember);
    }

    public Method getAnnotatedMethod() {
        return this.annotatedMethod;
    }

    public String toString() {
        return "Method " + this.annotatedMethod + " is annotated with @" + this.annotation.getSimpleName() + " and called by " + this.callingMember;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotatedMethodCallerResult that = (AnnotatedMethodCallerResult)o;
        return this.annotation.getSimpleName().equals(that.annotation.getSimpleName()) && this.annotatedMethod.getName().equals(that.annotatedMethod.getName()) && this.callingMember.getName().equals(that.callingMember.getName());
    }

    public int hashCode() {
        return Objects.hash(this.annotation.getSimpleName(), this.annotatedMethod.getName(), this.callingMember.getName());
    }
}

