/*
 * Decompiled with CFR 0.152.
 */
package com.azure.sdk.build.tool.util;

import com.azure.sdk.build.tool.models.BuildError;
import com.azure.sdk.build.tool.models.BuildErrorCode;
import com.azure.sdk.build.tool.models.BuildErrorLevel;
import com.azure.sdk.build.tool.mojo.AzureSdkMojo;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.maven.artifact.Artifact;

public final class MojoUtils {
    private static final ResourceBundle STRINGS = ResourceBundle.getBundle("strings");

    private MojoUtils() {
    }

    public static Set<Artifact> getDirectDependencies() {
        return AzureSdkMojo.getMojo().getProject().getDependencyArtifacts();
    }

    public static Set<Artifact> getAllDependencies() {
        return AzureSdkMojo.getMojo().getProject().getArtifacts();
    }

    public static List<String> getCompileSourceRoots() {
        return AzureSdkMojo.getMojo().getProject().getCompileSourceRoots();
    }

    public static String getString(String key) {
        return STRINGS.getString(key);
    }

    public static String getString(String key, String ... parameters) {
        return MessageFormat.format(MojoUtils.getString(key), parameters);
    }

    public static void failOrWarn(Supplier<Boolean> condition, BuildErrorCode errorCode, String message) {
        MojoUtils.failOrWarn(condition, errorCode, message, null);
    }

    public static void failOrWarn(Supplier<Boolean> condition, BuildErrorCode errorCode, String message, List<String> additionalDetails) {
        BuildError buildError = condition.get() != false ? new BuildError(message, errorCode, BuildErrorLevel.ERROR, additionalDetails) : new BuildError(message, errorCode, BuildErrorLevel.WARNING, additionalDetails);
        AzureSdkMojo.getMojo().getReport().addError(buildError);
    }
}

