/*
 * Decompiled with CFR 0.152.
 */
package com.azure.tools.codesnippetplugin.implementation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SnippetDictionary {
    private final Map<String, List<String>> snippetDictionary = new HashMap<String, List<String>>();
    private final List<String> missingBeginTag = new ArrayList<String>();

    public boolean isActive() {
        return !this.snippetDictionary.isEmpty();
    }

    public List<String> getMissingEndTags() {
        return new ArrayList<String>(this.snippetDictionary.keySet());
    }

    public List<String> getMissingBeginTags() {
        return this.missingBeginTag;
    }

    public void beginSnippet(String key) {
        if (!this.snippetDictionary.containsKey(key)) {
            this.snippetDictionary.put(key, new ArrayList());
        }
    }

    public void processLine(String line) {
        for (Map.Entry<String, List<String>> entry : this.snippetDictionary.entrySet()) {
            entry.getValue().add(line);
        }
    }

    public List<String> finalizeSnippet(String key) {
        List<String> value = null;
        if (this.snippetDictionary.containsKey(key)) {
            value = this.snippetDictionary.remove(key);
        } else {
            this.missingBeginTag.add(key);
        }
        return value;
    }
}

