/*
 * Decompiled with CFR 0.152.
 */
package com.azure.tools.codesnippetplugin;

import com.azure.tools.codesnippetplugin.ExecutionMode;
import com.azure.tools.codesnippetplugin.implementation.SnippetReplacer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class SnippetBaseMojo
extends AbstractMojo {
    public static final String DEFAULT_CODESNIPPET_GLOB = "**/src/samples/java/**/*.java";
    public static final String DEFAULT_SOURCE_GLOB = "**/src/main/java/**/*.java";
    @Parameter(property="codesnippetGlob", defaultValue="**/src/samples/java/**/*.java")
    private String codesnippetGlob;
    @Parameter(property="codesnippetRootDirectory", defaultValue="${project.basedir}/src/samples/java")
    private File codesnippetRootDirectory;
    @Parameter(property="sourceGlob", defaultValue="**/src/main/java/**/*.java")
    private String sourceGlob;
    @Parameter(property="sourceRootDirectory", defaultValue="${project.basedir}/src/main/java")
    private File sourceRootDirectory;
    @Parameter(property="includeSource", defaultValue="true")
    private boolean includeSource;
    @Parameter(property="readmePath", defaultValue="${project.basedir}/README.md")
    private File readmePath;
    @Parameter(property="includeReadme", defaultValue="true")
    private boolean includeReadme;
    @Parameter(property="maxLineLength", defaultValue="120")
    private int maxLineLength;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;

    protected String getCodesnippetGlob() {
        return this.codesnippetGlob;
    }

    protected File getCodesnippetRootDirectory() {
        return this.codesnippetRootDirectory;
    }

    protected String getSourceGlob() {
        return this.sourceGlob;
    }

    protected File getSourceRootDirectory() {
        return this.sourceRootDirectory;
    }

    protected boolean isIncludeSource() {
        return this.includeSource;
    }

    protected File getReadmePath() {
        return this.readmePath;
    }

    protected boolean isIncludeReadme() {
        return this.includeReadme;
    }

    protected int getMaxLineLength() {
        return this.maxLineLength;
    }

    protected boolean isSkip() {
        return this.skip;
    }

    protected void executeCodesnippet(ExecutionMode executionMode) throws MojoExecutionException {
        Log log = this.getLog();
        if (this.isSkip()) {
            log.info((CharSequence)"Skipping codesnippet execution since skip is set.");
            return;
        }
        Path codesnippetRootDirectory = this.getCodesnippetRootDirectory().toPath();
        log.debug((CharSequence)String.format("Using codesnippet root directory: %s", codesnippetRootDirectory));
        String codesnippetGlob = this.getCodesnippetGlob();
        log.debug((CharSequence)String.format("Using codesnippet glob: %s", codesnippetGlob));
        Path sourcesRootDirectory = this.getSourceRootDirectory().toPath();
        log.debug((CharSequence)String.format("Using sources root directory: %s", sourcesRootDirectory));
        String sourcesGlob = this.getSourceGlob();
        log.debug((CharSequence)String.format("Using source glob: %s", sourcesGlob));
        boolean includeSource = this.isIncludeSource();
        log.debug((CharSequence)String.format("Is source included? %b", includeSource));
        Path readmePath = this.getReadmePath().toPath();
        log.debug((CharSequence)String.format("Using README path: %s", readmePath));
        boolean includeReadme = this.isIncludeReadme();
        log.debug((CharSequence)String.format("Is README included? %b", includeSource));
        int maxLineLength = this.getMaxLineLength();
        log.debug((CharSequence)String.format("Using max line length: %d", maxLineLength));
        if (executionMode == ExecutionMode.UPDATE) {
            try {
                log.debug((CharSequence)"Beginning codesnippet update execution.");
                SnippetReplacer.updateCodesnippets(codesnippetRootDirectory, codesnippetGlob, sourcesRootDirectory, sourcesGlob, includeSource, readmePath, includeReadme, maxLineLength, log);
                log.debug((CharSequence)"Completed codesnippet update execution.");
            }
            catch (IOException ex) {
                log.error((Throwable)ex);
                throw new MojoExecutionException("Failed to update codesnippets.", (Exception)ex);
            }
        } else if (executionMode == ExecutionMode.VERIFY) {
            try {
                log.debug((CharSequence)"Beginning codesnippet verification execution.");
                SnippetReplacer.verifyCodesnippets(codesnippetRootDirectory, codesnippetGlob, sourcesRootDirectory, sourcesGlob, includeSource, readmePath, includeReadme, maxLineLength, log);
                log.debug((CharSequence)"Completed codesnippet verification execution.");
            }
            catch (IOException ex) {
                log.error((Throwable)ex);
                throw new MojoExecutionException("Failed to verify codesnippets.", (Exception)ex);
            }
        } else {
            throw new MojoExecutionException("Unsupported execution mode '" + (Object)((Object)executionMode) + "' provided.");
        }
    }
}

