/*
 * Decompiled with CFR 0.152.
 */
package com.azure.tools.codesnippetplugin;

import com.azure.tools.codesnippetplugin.ExecutionMode;
import com.azure.tools.codesnippetplugin.RootAndGlob;
import com.azure.tools.codesnippetplugin.implementation.SnippetReplacer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class SnippetBaseMojo
extends AbstractMojo {
    private static final String PROPERTY_PREFIX = "codesnippet.";
    public static final String DEFAULT_CODESNIPPET_GLOB = "**/src/samples/java/**/*.java";
    public static final String DEFAULT_SOURCE_GLOB = "**/src/main/java/**/*.java";
    public static final String DEFAULT_README_GLOB = "**/README.md";
    @Parameter(property="codesnippet.codesnippetGlob", defaultValue="**/src/samples/java/**/*.java")
    private String codesnippetGlob;
    @Parameter(property="codesnippet.codesnippetRootDirectory", defaultValue="${project.basedir}/src/samples/java")
    private File codesnippetRootDirectory;
    @Parameter
    private RootAndGlob[] additionalCodesnippets;
    @Parameter(property="codesnippet.sourceGlob", defaultValue="**/src/main/java/**/*.java")
    private String sourceGlob;
    @Parameter(property="codesnippet.sourceRootDirectory", defaultValue="${project.basedir}/src/main/java")
    private File sourceRootDirectory;
    @Parameter(property="codesnippet.includeSource", defaultValue="true")
    private boolean includeSource;
    @Parameter(property="codesnippet.readmeGlob", defaultValue="**/README.md")
    private String readmeGlob;
    @Parameter(property="codesnippet.readmeRootDirectory", defaultValue="${project.basedir}")
    private File readmeRootDirectory;
    @Parameter
    private RootAndGlob[] additionalReadmes;
    @Parameter(property="codesnippet.includeReadme", defaultValue="true")
    private boolean includeReadme;
    @Parameter(property="codesnippet.maxLineLength", defaultValue="120")
    private int maxLineLength;
    @Parameter(property="codesnippet.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="codesnippet.failOnError", defaultValue="true")
    private boolean failOnError;

    protected void executeCodesnippet(ExecutionMode executionMode) throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (this.skip) {
            log.info((CharSequence)"Skipping codesnippet execution since skip is set.");
            return;
        }
        RootAndGlob codesnippetRootAndGlob = new RootAndGlob().setRoot(SnippetBaseMojo.logConfiguration("Using codesnippet root directory: %s", this.codesnippetRootDirectory, log)).setGlob(SnippetBaseMojo.logConfiguration("Using codesnippet glob: %s", this.codesnippetGlob, log));
        List<RootAndGlob> additionalCodesnippetRootAndGlobs = SnippetBaseMojo.processRootAndGlobs(this.additionalCodesnippets, DEFAULT_CODESNIPPET_GLOB);
        if (!additionalCodesnippetRootAndGlobs.isEmpty()) {
            log.debug((CharSequence)"Using additional codesnippet roots and globs:");
            for (RootAndGlob rootAndGlob : additionalCodesnippetRootAndGlobs) {
                log.debug((CharSequence)String.format("\tRoot: %s, Glob: %s", rootAndGlob.getRoot(), rootAndGlob.getGlob()));
            }
        }
        RootAndGlob sourcesRootAndGlob = new RootAndGlob().setRoot(SnippetBaseMojo.logConfiguration("Using sources root directory: %s", this.sourceRootDirectory, log)).setGlob(SnippetBaseMojo.logConfiguration("Using source glob: %s", this.sourceGlob, log));
        SnippetBaseMojo.logConfiguration("Is source included? %b", this.includeSource, log);
        RootAndGlob readmeRootAndGlob = new RootAndGlob().setRoot(SnippetBaseMojo.logConfiguration("Using README root directory: %s", this.readmeRootDirectory, log)).setGlob(SnippetBaseMojo.logConfiguration("Using README glob: %s", this.readmeGlob, log));
        List<RootAndGlob> additionalReadmeRootAndGlobs = SnippetBaseMojo.processRootAndGlobs(this.additionalReadmes, DEFAULT_README_GLOB);
        if (!additionalReadmeRootAndGlobs.isEmpty()) {
            log.debug((CharSequence)"Using additional README roots and globs:");
            for (RootAndGlob rootAndGlob : additionalReadmeRootAndGlobs) {
                log.debug((CharSequence)String.format("\tRoot: %s, Glob: %s", rootAndGlob.getRoot(), rootAndGlob.getGlob()));
            }
        }
        SnippetBaseMojo.logConfiguration("Is README included? %b", this.includeReadme, log);
        SnippetBaseMojo.logConfiguration("Using max line length: %d", this.maxLineLength, log);
        SnippetBaseMojo.logConfiguration("Should fail on error: %b", this.failOnError, log);
        if (executionMode == ExecutionMode.UPDATE) {
            try {
                log.debug((CharSequence)"Beginning codesnippet update execution.");
                SnippetReplacer.updateCodesnippets(codesnippetRootAndGlob, additionalCodesnippetRootAndGlobs, sourcesRootAndGlob, this.includeSource, readmeRootAndGlob, additionalReadmeRootAndGlobs, this.includeReadme, this.maxLineLength, this.failOnError, log);
                log.debug((CharSequence)"Completed codesnippet update execution.");
            }
            catch (IOException ex) {
                log.error((Throwable)ex);
                throw new MojoFailureException("Failed to update codesnippets.", (Throwable)ex);
            }
        } else if (executionMode == ExecutionMode.VERIFY) {
            try {
                log.debug((CharSequence)"Beginning codesnippet verification execution.");
                SnippetReplacer.verifyCodesnippets(codesnippetRootAndGlob, additionalCodesnippetRootAndGlobs, sourcesRootAndGlob, this.includeSource, readmeRootAndGlob, additionalReadmeRootAndGlobs, this.includeReadme, this.maxLineLength, this.failOnError, log);
                log.debug((CharSequence)"Completed codesnippet verification execution.");
            }
            catch (IOException ex) {
                log.error((Throwable)ex);
                throw new MojoFailureException("Failed to verify codesnippets.", (Throwable)ex);
            }
        } else {
            throw new MojoFailureException("Unsupported execution mode '" + (Object)((Object)executionMode) + "' provided.");
        }
    }

    private static <T> T logConfiguration(String formattable, T configuration, Log log) {
        log.debug((CharSequence)String.format(formattable, configuration));
        return configuration;
    }

    private static List<RootAndGlob> processRootAndGlobs(RootAndGlob[] rootAndGlobs, String defaultGlob) {
        if (rootAndGlobs == null) {
            return new ArrayList<RootAndGlob>();
        }
        for (RootAndGlob rootAndGlob : rootAndGlobs) {
            if (rootAndGlob.getGlob() != null) continue;
            rootAndGlob.setGlob(defaultGlob);
        }
        return Arrays.stream(rootAndGlobs).collect(Collectors.toList());
    }
}

