/*
 * Decompiled with CFR 0.152.
 */
package com.azure.tools.codesnippetplugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.maven.plugins.annotations.Parameter;

public final class RootAndGlob {
    @Parameter
    private File root;
    @Parameter
    private String glob;

    public File getRoot() {
        return this.root;
    }

    public RootAndGlob setRoot(File root) {
        this.root = Objects.requireNonNull(root, "'root' cannot be null.");
        return this;
    }

    public boolean rootExists() {
        return this.root.exists();
    }

    public String getGlob() {
        return this.glob;
    }

    public RootAndGlob setGlob(String glob) {
        this.glob = Objects.requireNonNull(glob, "'glob' cannot be null.");
        return this;
    }

    public List<Path> globFiles() throws IOException {
        final ArrayList<Path> locatedPaths = new ArrayList<Path>();
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + this.glob);
        Files.walkFileTree(this.root.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (pathMatcher.matches(file)) {
                    locatedPaths.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        return locatedPaths;
    }
}

