/*
 * Decompiled with CFR 0.152.
 */
package com.azure.tools.codesnippetplugin.implementation;

import java.util.Objects;
import java.util.regex.Pattern;

final class CodesnippetReplacement {
    private final String target;
    private final String replacement;
    private final Pattern optionalPattern;
    private final char targetChar;

    CodesnippetReplacement(String target, String replacement) {
        this.target = Objects.requireNonNull(target);
        this.replacement = replacement;
        if (target.length() == 1) {
            this.targetChar = target.charAt(0);
            this.optionalPattern = null;
        } else {
            this.optionalPattern = Pattern.compile(target);
            this.targetChar = '\u0000';
        }
    }

    String replaceCodesnippet(String codesnippet) {
        if (codesnippet == null || codesnippet.isEmpty()) {
            return codesnippet;
        }
        if (this.optionalPattern != null) {
            return this.optionalPattern.matcher(codesnippet).replaceAll(this.replacement);
        }
        StringBuilder replacer = null;
        int prevStart = 0;
        for (int i = 0; i < codesnippet.length(); ++i) {
            if (codesnippet.charAt(i) != this.targetChar) continue;
            if (replacer == null) {
                replacer = new StringBuilder(codesnippet.length() + (this.replacement.length() - this.target.length()) * 50);
            }
            if (prevStart != i) {
                replacer.append(codesnippet, prevStart, i);
            }
            replacer.append(this.replacement);
            prevStart = i + 1;
        }
        if (replacer == null) {
            return codesnippet;
        }
        replacer.append(codesnippet, prevStart, codesnippet.length());
        return replacer.toString();
    }
}

