/*
 * Decompiled with CFR 0.152.
 */
package com.azure.tools.codesnippetplugin.implementation;

import com.azure.tools.codesnippetplugin.ExecutionMode;
import com.azure.tools.codesnippetplugin.RootAndGlob;
import com.azure.tools.codesnippetplugin.implementation.Codesnippet;
import com.azure.tools.codesnippetplugin.implementation.CodesnippetError;
import com.azure.tools.codesnippetplugin.implementation.CodesnippetLengthError;
import com.azure.tools.codesnippetplugin.implementation.CodesnippetMismatchError;
import com.azure.tools.codesnippetplugin.implementation.CodesnippetMissingError;
import com.azure.tools.codesnippetplugin.implementation.CodesnippetReplacement;
import com.azure.tools.codesnippetplugin.implementation.SnippetDictionary;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class SnippetReplacer {
    private static final String SNIPPET_ID_CAPTURE = "\\s*([a-zA-Z0-9.#\\-_]+)\\s*";
    private static final Pattern SNIPPET_DEF_BEGIN = Pattern.compile(String.format("\\s*//\\s*BEGIN:%s", "\\s*([a-zA-Z0-9.#\\-_]+)\\s*"));
    private static final Pattern SNIPPET_DEF_END = Pattern.compile(String.format("\\s*//\\s*END:%s", "\\s*([a-zA-Z0-9.#\\-_]+)\\s*"));
    private static final Pattern SNIPPET_SRC_CALL_BEGIN = Pattern.compile(String.format("(\\s*)\\*?\\s*<!--\\s*src_embed%s-->", "\\s*([a-zA-Z0-9.#\\-_]+)\\s*"));
    private static final Pattern SNIPPET_SRC_CALL_END = Pattern.compile(String.format("(\\s*)\\*?\\s*<!--\\s*end%s-->", "\\s*([a-zA-Z0-9.#\\-_]+)\\s*"));
    private static final Pattern SNIPPET_README_CALL_BEGIN = Pattern.compile(String.format("(\\s*)?```(\\s*)?java%s", "\\s*([a-zA-Z0-9.#\\-_]+)\\s*"));
    private static final Pattern SNIPPET_README_CALL_END = Pattern.compile("(\\s*)?```\\s*");
    private static final Pattern WHITESPACE_EXTRACTION = Pattern.compile("(\\s*)(.*)");
    private static final Pattern END_OF_LINE_WHITESPACES = Pattern.compile("\\s+$");
    private static final String JAVADOC_PRE_FENCE = "<pre>";
    private static final String JAVADOC_POST_FENCE = "</pre>";
    private static final List<CodesnippetReplacement> CODESNIPPET_REPLACEMENTS = new ArrayList<CodesnippetReplacement>();

    public static void verifyCodesnippets(RootAndGlob codesnippetRootAndGlob, List<RootAndGlob> additionalCodesnippets, RootAndGlob sourcesRootAndGlob, boolean includeSources, RootAndGlob readmeRootAndGlob, List<RootAndGlob> additionalReadmes, boolean includeReadme, int maxLineLength, boolean failOnError, Log logger) throws IOException, MojoExecutionException {
        SnippetReplacer.runCodesnippets(codesnippetRootAndGlob, additionalCodesnippets, sourcesRootAndGlob, includeSources, readmeRootAndGlob, additionalReadmes, includeReadme, maxLineLength, failOnError, ExecutionMode.VERIFY, logger);
    }

    static List<CodesnippetError> verifyReadmeCodesnippets(Path file, Map<String, Codesnippet> snippetMap) throws IOException {
        return SnippetReplacer.verifySnippets(file, SNIPPET_README_CALL_BEGIN, 3, SNIPPET_README_CALL_END, snippetMap, "", "", 0, "", Collections.emptyList(), Integer.MAX_VALUE, true);
    }

    static List<CodesnippetError> verifySourceCodeSnippets(Path file, Map<String, Codesnippet> snippetMap, int maxLineLength) throws IOException {
        return SnippetReplacer.verifySnippets(file, SNIPPET_SRC_CALL_BEGIN, 2, SNIPPET_SRC_CALL_END, snippetMap, JAVADOC_PRE_FENCE, JAVADOC_POST_FENCE, 1, "* ", CODESNIPPET_REPLACEMENTS, maxLineLength, false);
    }

    public static void updateCodesnippets(RootAndGlob codesnippetRootAndGlob, List<RootAndGlob> additionalCodesnippets, RootAndGlob sourcesRootAndGlob, boolean includeSources, RootAndGlob readmeRootAndGlob, List<RootAndGlob> additionalReadmes, boolean includeReadme, int maxLineLength, boolean failOnError, Log logger) throws IOException, MojoExecutionException {
        SnippetReplacer.runCodesnippets(codesnippetRootAndGlob, additionalCodesnippets, sourcesRootAndGlob, includeSources, readmeRootAndGlob, additionalReadmes, includeReadme, maxLineLength, failOnError, ExecutionMode.UPDATE, logger);
    }

    private static void runCodesnippets(RootAndGlob codesnippetRootAndGlob, List<RootAndGlob> additionalCodesnippets, RootAndGlob sourcesRootAndGlob, boolean includeSources, RootAndGlob readmeRootAndGlob, List<RootAndGlob> additionalReadmes, boolean includeReadme, int maxLineLength, boolean failOnError, ExecutionMode mode, Log logger) throws IOException, MojoExecutionException {
        if (!includeSources && !includeReadme) {
            logger.debug((CharSequence)"Neither sources or README were included. No codesnippet updating will be done.");
            return;
        }
        List<Object> sourceFiles = Collections.emptyList();
        if (includeSources && sourcesRootAndGlob.rootExists()) {
            sourceFiles = sourcesRootAndGlob.globFiles();
        }
        List<Object> readmeFiles = new ArrayList();
        if (includeReadme) {
            if (readmeRootAndGlob.rootExists()) {
                readmeFiles = readmeRootAndGlob.globFiles();
            }
            for (RootAndGlob rootAndGlob : additionalReadmes) {
                readmeFiles.addAll(rootAndGlob.globFiles());
            }
        }
        if (sourceFiles.isEmpty() && readmeFiles.isEmpty()) {
            logger.info((CharSequence)"No files to update.");
            return;
        }
        List<Path> codesnippetFiles = codesnippetRootAndGlob.globFiles();
        for (RootAndGlob additionalCodesnippet : additionalCodesnippets) {
            codesnippetFiles.addAll(additionalCodesnippet.globFiles());
        }
        Map<String, Codesnippet> map = SnippetReplacer.getAllSnippets(codesnippetFiles);
        ArrayList<CodesnippetError> errors = new ArrayList<CodesnippetError>();
        for (Path path : sourceFiles) {
            if (mode == ExecutionMode.UPDATE) {
                errors.addAll(SnippetReplacer.updateSourceCodeSnippets(path, map, maxLineLength));
                continue;
            }
            errors.addAll(SnippetReplacer.verifySourceCodeSnippets(path, map, maxLineLength));
        }
        for (Path path : readmeFiles) {
            if (mode == ExecutionMode.UPDATE) {
                errors.addAll(SnippetReplacer.updateReadmeCodesnippets(path, map));
                continue;
            }
            errors.addAll(SnippetReplacer.verifyReadmeCodesnippets(path, map));
        }
        if (!errors.isEmpty()) {
            String errorMessage = SnippetReplacer.createErrorMessage(mode == ExecutionMode.UPDATE ? "updating" : "verifying", maxLineLength, errors);
            logger.error((CharSequence)errorMessage);
            if (failOnError) {
                throw new MojoExecutionException(errorMessage);
            }
        }
    }

    static List<CodesnippetError> updateReadmeCodesnippets(Path file, Map<String, Codesnippet> snippetMap) throws IOException {
        return SnippetReplacer.updateSnippets(file, SNIPPET_README_CALL_BEGIN, SNIPPET_README_CALL_END, 3, snippetMap, "", "", 0, "", Collections.emptyList(), Integer.MAX_VALUE, true);
    }

    static List<CodesnippetError> updateSourceCodeSnippets(Path file, Map<String, Codesnippet> snippetMap, int maxLineLength) throws IOException {
        return SnippetReplacer.updateSnippets(file, SNIPPET_SRC_CALL_BEGIN, SNIPPET_SRC_CALL_END, 2, snippetMap, JAVADOC_PRE_FENCE, JAVADOC_POST_FENCE, 1, "* ", CODESNIPPET_REPLACEMENTS, maxLineLength, false);
    }

    private static List<CodesnippetError> updateSnippets(Path file, Pattern beginRegex, Pattern endRegex, int snippetIdGroup, Map<String, Codesnippet> snippetMap, String preFence, String postFence, int prefixGroupNum, String additionalLinePrefix, List<CodesnippetReplacement> replacements, int maxLineLength, boolean prependSnippetTagIndentation) throws IOException {
        List<String> lines = Files.readAllLines(file, StandardCharsets.UTF_8);
        ArrayList<CodesnippetError> updateErrors = new ArrayList<CodesnippetError>();
        ArrayList<String> modifiedLines = new ArrayList<String>();
        boolean inSnippet = false;
        boolean needsAmend = false;
        String lineSep = System.lineSeparator();
        String currentSnippetId = "";
        int snippetTagIndentation = 0;
        for (String line : lines) {
            Matcher begin = beginRegex.matcher(line);
            Matcher end = endRegex.matcher(line);
            if (begin.matches()) {
                modifiedLines.add(line);
                modifiedLines.add(lineSep);
                currentSnippetId = begin.group(snippetIdGroup);
                if (prependSnippetTagIndentation) {
                    snippetTagIndentation = begin.group(1).length();
                }
                inSnippet = true;
                continue;
            }
            if (end.matches()) {
                if (inSnippet) {
                    if (!snippetMap.containsKey(currentSnippetId)) {
                        updateErrors.add(new CodesnippetMissingError(currentSnippetId, file));
                        needsAmend = true;
                        inSnippet = false;
                        modifiedLines.add(line);
                        modifiedLines.add(lineSep);
                        continue;
                    }
                    Codesnippet newSnippets = snippetMap.get(currentSnippetId);
                    ArrayList<String> modifiedSnippets = new ArrayList<String>();
                    String linePrefix = SnippetReplacer.prefixFunction(end, prefixGroupNum, additionalLinePrefix);
                    int longestSnippetLine = 0;
                    StringBuilder snippetIndentationBuilder = new StringBuilder();
                    for (int i = 0; i < snippetTagIndentation; ++i) {
                        snippetIndentationBuilder.append(" ");
                    }
                    String snippetIndentation = snippetIndentationBuilder.toString();
                    for (String snippet : SnippetReplacer.respaceLines(newSnippets.getContent())) {
                        longestSnippetLine = Math.max(longestSnippetLine, snippet.length());
                        String modifiedSnippet = SnippetReplacer.applyReplacements(snippet, replacements);
                        modifiedSnippets.add(modifiedSnippet.length() == 0 ? END_OF_LINE_WHITESPACES.matcher(linePrefix).replaceAll("") + lineSep : snippetIndentation + linePrefix + modifiedSnippet + lineSep);
                    }
                    if (longestSnippetLine > maxLineLength) {
                        updateErrors.add(new CodesnippetLengthError(currentSnippetId, file, longestSnippetLine));
                    }
                    if (preFence != null && preFence.length() > 0) {
                        modifiedLines.add(linePrefix);
                        modifiedLines.add(preFence);
                        modifiedLines.add(lineSep);
                    }
                    modifiedLines.addAll(modifiedSnippets);
                    if (postFence != null && postFence.length() > 0) {
                        modifiedLines.add(linePrefix);
                        modifiedLines.add(postFence);
                        modifiedLines.add(lineSep);
                    }
                    modifiedLines.add(line);
                    modifiedLines.add(lineSep);
                    needsAmend = true;
                    inSnippet = false;
                    continue;
                }
                modifiedLines.add(line);
                modifiedLines.add(lineSep);
                continue;
            }
            if (inSnippet) continue;
            modifiedLines.add(line);
            modifiedLines.add(lineSep);
        }
        if (needsAmend) {
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
                for (String line : modifiedLines) {
                    writer.write(line);
                }
            }
        }
        return updateErrors;
    }

    private static List<CodesnippetError> verifySnippets(Path file, Pattern beginRegex, int snippetIdGroup, Pattern endRegex, Map<String, Codesnippet> snippetMap, String preFence, String postFence, int prefixGroupNum, String additionalLinePrefix, List<CodesnippetReplacement> replacements, int maxLineLength, boolean prependSnippetTagIndentation) throws IOException {
        List<String> lines = Files.readAllLines(file, StandardCharsets.UTF_8);
        boolean inSnippet = false;
        String lineSep = System.lineSeparator();
        ArrayList<String> currentSnippetSet = null;
        ArrayList<CodesnippetError> verificationErrors = new ArrayList<CodesnippetError>();
        String currentSnippetId = "";
        int snippetTagIndentation = 0;
        for (String line : lines) {
            Matcher begin = beginRegex.matcher(line);
            Matcher end = endRegex.matcher(line);
            if (begin.matches()) {
                currentSnippetId = begin.group(snippetIdGroup);
                inSnippet = true;
                if (prependSnippetTagIndentation) {
                    snippetTagIndentation = begin.group(1).length();
                }
                currentSnippetSet = new ArrayList<String>();
                continue;
            }
            if (end.matches()) {
                if (!inSnippet) continue;
                if (!snippetMap.containsKey(currentSnippetId)) {
                    verificationErrors.add(new CodesnippetMissingError(currentSnippetId, file));
                    inSnippet = false;
                    currentSnippetSet = null;
                    continue;
                }
                Codesnippet newSnippets = snippetMap.get(currentSnippetId);
                ArrayList<String> modifiedSnippets = new ArrayList<String>();
                String linePrefix = SnippetReplacer.prefixFunction(end, prefixGroupNum, additionalLinePrefix);
                int longestSnippetLine = 0;
                StringBuilder snippetIndentationBuilder = new StringBuilder();
                for (int i = 0; i < snippetTagIndentation; ++i) {
                    snippetIndentationBuilder.append(" ");
                }
                String snippetIndentation = snippetIndentationBuilder.toString();
                for (String snippet : SnippetReplacer.respaceLines(newSnippets.getContent())) {
                    longestSnippetLine = Math.max(longestSnippetLine, snippet.length());
                    String modifiedSnippet = SnippetReplacer.applyReplacements(snippet, replacements);
                    modifiedSnippets.add(modifiedSnippet.length() == 0 ? END_OF_LINE_WHITESPACES.matcher(linePrefix).replaceAll("") + lineSep : snippetIndentation + linePrefix + modifiedSnippet + lineSep);
                }
                if (longestSnippetLine > maxLineLength) {
                    verificationErrors.add(new CodesnippetLengthError(currentSnippetId, file, longestSnippetLine));
                }
                if (!modifiedSnippets.equals(currentSnippetSet)) {
                    verificationErrors.add(new CodesnippetMismatchError(currentSnippetId, file));
                }
                inSnippet = false;
                currentSnippetSet = null;
                continue;
            }
            if (!inSnippet) continue;
            if (preFence.length() > 0 && postFence.length() > 0) {
                if (line.contains(preFence) || line.contains(postFence)) continue;
                currentSnippetSet.add(line + lineSep);
                continue;
            }
            currentSnippetSet.add(line + lineSep);
        }
        return verificationErrors;
    }

    static Map<String, Codesnippet> getAllSnippets(List<Path> snippetSources) throws IOException, MojoExecutionException {
        HashMap<String, List<Codesnippet>> codesnippets = new HashMap<String, List<Codesnippet>>();
        for (Path samplePath : snippetSources) {
            List<String> fileContent = Files.readAllLines(samplePath, StandardCharsets.UTF_8);
            SnippetDictionary snippetReader = new SnippetDictionary();
            for (String line : fileContent) {
                Matcher begin = SNIPPET_DEF_BEGIN.matcher(line);
                Matcher end = SNIPPET_DEF_END.matcher(line);
                if (begin.matches()) {
                    String id_beginning = begin.group(1);
                    snippetReader.beginSnippet(id_beginning);
                    continue;
                }
                if (end.matches()) {
                    String id_ending = end.group(1);
                    List<String> snippetContent = snippetReader.finalizeSnippet(id_ending);
                    codesnippets.compute(id_ending, (key, value) -> {
                        if (value == null) {
                            value = new ArrayList<Codesnippet>();
                        }
                        value.add(new Codesnippet((String)key, samplePath, snippetContent));
                        return value;
                    });
                    continue;
                }
                if (!snippetReader.isActive()) continue;
                snippetReader.processLine(line);
            }
        }
        String potentialErrorMessage = SnippetReplacer.createDuplicateCodesnippetErrorMessage(codesnippets);
        if (!potentialErrorMessage.isEmpty()) {
            throw new MojoExecutionException(potentialErrorMessage);
        }
        return codesnippets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Codesnippet)((List)entry.getValue()).get(0)));
    }

    private static String createDuplicateCodesnippetErrorMessage(Map<String, List<Codesnippet>> codesnippets) {
        StringBuilder errorMessage = new StringBuilder();
        for (Map.Entry<String, List<Codesnippet>> codesnippetsById : codesnippets.entrySet()) {
            if (codesnippetsById.getValue().size() == 1) continue;
            if (errorMessage.length() == 0) {
                errorMessage.append("Multiple codesnippets used the same identifier:").append(System.lineSeparator()).append(System.lineSeparator());
            }
            errorMessage.append("Codesnippet ID '").append(codesnippetsById.getKey()).append("' was used multiple times. Found in files:").append(System.lineSeparator());
            for (Codesnippet codesnippet : codesnippetsById.getValue()) {
                errorMessage.append("--> ").append(codesnippet.getDefinitionLocation()).append(System.lineSeparator());
            }
            errorMessage.append(System.lineSeparator());
        }
        return errorMessage.toString();
    }

    private static List<String> respaceLines(List<String> snippetText) {
        String minWhitespace = null;
        ArrayList<String> modifiedStrings = new ArrayList<String>();
        for (String snippetLine : snippetText) {
            Matcher leadSpaceMatch;
            if (snippetLine.trim().length() == 0 || !(leadSpaceMatch = WHITESPACE_EXTRACTION.matcher(snippetLine)).matches()) continue;
            String leadSpace = leadSpaceMatch.group(1);
            if (minWhitespace != null && leadSpace.length() >= minWhitespace.length()) continue;
            minWhitespace = leadSpace;
        }
        if (minWhitespace != null) {
            Pattern minWhitespacePattern = Pattern.compile(minWhitespace);
            for (String snippetLine : snippetText) {
                modifiedStrings.add(minWhitespacePattern.matcher(snippetLine).replaceFirst(""));
            }
        }
        return modifiedStrings;
    }

    private static String prefixFunction(Matcher match, int groupNum, String additionalPrefix) {
        if (match == null || groupNum < 1) {
            return "";
        }
        return match.group(groupNum) + additionalPrefix;
    }

    private static String applyReplacements(String snippet, List<CodesnippetReplacement> replacements) {
        if (replacements.isEmpty()) {
            return snippet;
        }
        for (CodesnippetReplacement replacement : replacements) {
            snippet = replacement.replaceCodesnippet(snippet);
        }
        return snippet;
    }

    private static String createErrorMessage(String operationKind, int allowedLength, List<CodesnippetError> errors) {
        List lengthErrorMessages;
        List missingErrorMessages;
        StringBuilder errorMessageBuilder = new StringBuilder("codesnippet-maven-plugin has encountered errors while ").append(operationKind).append(" codesnippets.").append(System.lineSeparator()).append(System.lineSeparator());
        List mismatchErrorMessages = errors.stream().filter(error -> error instanceof CodesnippetMismatchError).map(CodesnippetError::getErrorMessage).collect(Collectors.toList());
        if (!mismatchErrorMessages.isEmpty()) {
            errorMessageBuilder.append("The following codesnippets need updates:").append(System.lineSeparator());
            for (Object errorMessage : mismatchErrorMessages) {
                errorMessageBuilder.append((String)errorMessage).append(System.lineSeparator());
            }
        }
        if (!(missingErrorMessages = errors.stream().filter(error -> error instanceof CodesnippetMissingError).map(CodesnippetError::getErrorMessage).collect(Collectors.toList())).isEmpty()) {
            errorMessageBuilder.append(System.lineSeparator()).append("The following codesnippets were missing:").append(System.lineSeparator());
            for (String errorMessage : missingErrorMessages) {
                errorMessageBuilder.append(errorMessage).append(System.lineSeparator());
            }
        }
        if (!(lengthErrorMessages = errors.stream().filter(error -> error instanceof CodesnippetLengthError).map(CodesnippetError::getErrorMessage).collect(Collectors.toList())).isEmpty()) {
            errorMessageBuilder.append(System.lineSeparator()).append("The following codesnippets exceeded the allowed length(").append(allowedLength).append("):").append(System.lineSeparator());
            for (String errorMessage : lengthErrorMessages) {
                errorMessageBuilder.append(errorMessage).append(System.lineSeparator());
            }
        }
        return errorMessageBuilder.toString();
    }

    private SnippetReplacer() {
    }

    static {
        CODESNIPPET_REPLACEMENTS.add(new CodesnippetReplacement("&", "&amp;"));
        CODESNIPPET_REPLACEMENTS.add(new CodesnippetReplacement("\"", "&quot;"));
        CODESNIPPET_REPLACEMENTS.add(new CodesnippetReplacement(">", "&gt;"));
        CODESNIPPET_REPLACEMENTS.add(new CodesnippetReplacement("<", "&lt;"));
        CODESNIPPET_REPLACEMENTS.add(new CodesnippetReplacement("@", "&#64;"));
        CODESNIPPET_REPLACEMENTS.add(new CodesnippetReplacement("\\{", "&#123;"));
        CODESNIPPET_REPLACEMENTS.add(new CodesnippetReplacement("}", "&#125;"));
        CODESNIPPET_REPLACEMENTS.add(new CodesnippetReplacement("\\(", "&#40;"));
        CODESNIPPET_REPLACEMENTS.add(new CodesnippetReplacement("\\)", "&#41;"));
        CODESNIPPET_REPLACEMENTS.add(new CodesnippetReplacement("/", "&#47;"));
        CODESNIPPET_REPLACEMENTS.add(new CodesnippetReplacement("\\\\", "&#92;"));
    }
}

