/*
 * Decompiled with CFR 0.152.
 */
package com.azure.tracing.opentelemetry;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.implementation.http.policy.spi.AfterRetryPolicyProvider;
import com.azure.core.implementation.util.ImplUtils;
import com.azure.tracing.opentelemetry.implementation.HttpTraceUtil;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanBuilder;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.propagation.TextFormat;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.util.context.Context;

public class OpenTelemetryHttpPolicy
implements AfterRetryPolicyProvider,
HttpPipelinePolicy {
    private static final Tracer TRACER = Tracing.getTracer();
    private static final String OPENTELEMETRY_SPAN_KEY = "opentelemetry-span";
    private static final String HTTP_USER_AGENT = "http.user_agent";
    private static final String HTTP_METHOD = "http.method";
    private static final String HTTP_URL = "http.url";
    private static final String HTTP_STATUS_CODE = "http.status_code";
    private static final String REQUEST_ID = "x-ms-request-id";
    private final TextFormat traceContextFormat = Tracing.getPropagationComponent().getTraceContextFormat();
    private final TextFormat.Setter<HttpRequest> contextSetter = new TextFormat.Setter<HttpRequest>(){

        public void put(HttpRequest request, String key, String value) {
            request.header(key, value);
        }
    };

    public HttpPipelinePolicy create() {
        return this;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        SpanContext spanContext;
        Span parentSpan = context.getData(OPENTELEMETRY_SPAN_KEY).orElse(TRACER.getCurrentSpan());
        HttpRequest request = context.httpRequest();
        SpanBuilder spanBuilder = TRACER.spanBuilderWithExplicitParent(request.url().getPath(), parentSpan);
        spanBuilder.setSpanKind(Span.Kind.CLIENT);
        Span span = spanBuilder.startSpan();
        if (span.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            OpenTelemetryHttpPolicy.addSpanRequestAttributes(span, request);
        }
        if (!(spanContext = span.getContext()).equals((Object)SpanContext.INVALID)) {
            this.traceContextFormat.inject(spanContext, (Object)request, this.contextSetter);
        }
        return next.process().doOnEach(OpenTelemetryHttpPolicy::handleResponse).subscriberContext(Context.of((Object)"TRACING_SPAN", (Object)span, (Object)"REQUEST", (Object)request));
    }

    private static void addSpanRequestAttributes(Span span, HttpRequest request) {
        OpenTelemetryHttpPolicy.putAttributeIfNotEmptyOrNull(span, HTTP_USER_AGENT, request.headers().value("User-Agent"));
        OpenTelemetryHttpPolicy.putAttributeIfNotEmptyOrNull(span, HTTP_METHOD, request.httpMethod().toString());
        OpenTelemetryHttpPolicy.putAttributeIfNotEmptyOrNull(span, HTTP_URL, request.url().toString());
    }

    private static void putAttributeIfNotEmptyOrNull(Span span, String key, String value) {
        if (!ImplUtils.isNullOrEmpty((CharSequence)value)) {
            span.putAttribute(key, AttributeValue.stringAttributeValue((String)value));
        }
    }

    private static void handleResponse(Signal<HttpResponse> signal) {
        if (signal.isOnComplete() || signal.isOnSubscribe()) {
            return;
        }
        Context context = signal.getContext();
        Optional tracingSpan = context.getOrEmpty((Object)"TRACING_SPAN");
        if (!tracingSpan.isPresent()) {
            return;
        }
        Span span = (Span)tracingSpan.get();
        HttpResponse httpResponse = null;
        Throwable error = null;
        if (signal.isOnNext()) {
            httpResponse = (HttpResponse)signal.get();
        } else {
            error = signal.getThrowable();
            if (error instanceof HttpResponseException) {
                HttpResponseException exception = (HttpResponseException)error;
                httpResponse = exception.response();
            }
        }
        OpenTelemetryHttpPolicy.spanEnd(span, httpResponse, error);
    }

    private static void spanEnd(Span span, HttpResponse response, Throwable error) {
        if (span.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            int statusCode = 0;
            String requestId = null;
            if (response != null) {
                statusCode = response.statusCode();
                requestId = response.headerValue(REQUEST_ID);
            }
            OpenTelemetryHttpPolicy.putAttributeIfNotEmptyOrNull(span, REQUEST_ID, requestId);
            span.putAttribute(HTTP_STATUS_CODE, AttributeValue.longAttributeValue((long)statusCode));
            span.setStatus(HttpTraceUtil.parseResponseStatus(statusCode, error));
        }
        span.end();
    }
}

