/*
 * Decompiled with CFR 0.152.
 */
package com.azure.tracing.opentelemetry;

import com.azure.core.implementation.tracing.ProcessKind;
import com.azure.core.implementation.util.ImplUtils;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.tracing.opentelemetry.implementation.AmqpPropagationFormatUtil;
import com.azure.tracing.opentelemetry.implementation.AmqpTraceUtil;
import com.azure.tracing.opentelemetry.implementation.HttpTraceUtil;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Link;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanBuilder;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.Locale;
import java.util.Optional;

public class OpenTelemetryTracer
implements com.azure.core.implementation.tracing.Tracer {
    private static final Tracer TRACER = Tracing.getTracer();
    private static final String COMPONENT = "component";
    private static final String MESSAGE_BUS_DESTINATION = "message_bus.destination";
    private static final String PEER_ENDPOINT = "peer.address";
    private final ClientLogger logger = new ClientLogger(OpenTelemetryTracer.class);

    public Context start(String methodName, Context context) {
        Span parentSpan = context.getData((Object)"opentelemetry-span").orElse(TRACER.getCurrentSpan());
        String spanName = context.getData((Object)"opentelemetry-span-name").orElse(methodName);
        SpanBuilder spanBuilder = TRACER.spanBuilderWithExplicitParent(spanName, parentSpan);
        Span span = spanBuilder.startSpan();
        return context.addData((Object)"opentelemetry-span", (Object)span);
    }

    public Context start(String spanName, Context context, ProcessKind processKind) {
        switch (processKind) {
            case SEND: {
                SpanBuilder spanBuilder = this.startSpanWithExplicitParent(spanName, context);
                Span span = spanBuilder.setSpanKind(Span.Kind.CLIENT).startSpan();
                if (span.getOptions().contains(Span.Options.RECORD_EVENTS)) {
                    OpenTelemetryTracer.addSpanRequestAttributes(span, context, spanName);
                }
                return context.addData((Object)"opentelemetry-span", (Object)span);
            }
            case RECEIVE: {
                SpanBuilder spanBuilder = this.startSpanWithExplicitParent(spanName, context);
                Span span = spanBuilder.startSpan();
                context = this.setContextData(span);
                return context.addData((Object)"opentelemetry-span", (Object)span);
            }
            case PROCESS: {
                return this.startScopedSpan(spanName, context);
            }
        }
        return Context.NONE;
    }

    public void end(int responseCode, Throwable throwable, Context context) {
        Span span = this.getSpan(context);
        if (span == null) {
            return;
        }
        if (span.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            span.setStatus(HttpTraceUtil.parseResponseStatus(responseCode, throwable));
        }
        span.end();
    }

    public void setAttribute(String key, String value, Context context) {
        if (ImplUtils.isNullOrEmpty((CharSequence)value)) {
            this.logger.info("Failed to set span attribute since value is null or empty.", new Object[0]);
            return;
        }
        Span span = this.getSpan(context);
        if (span != null) {
            span.putAttribute(key, AttributeValue.stringAttributeValue((String)value));
        } else {
            this.logger.warning("Failed to find span to add attribute.", new Object[0]);
        }
    }

    public Context setSpanName(String spanName, Context context) {
        return context.addData((Object)"opentelemetry-span-name", (Object)spanName);
    }

    public void end(String statusMessage, Throwable throwable, Context context) {
        Span span = this.getSpan(context);
        if (span == null) {
            this.logger.warning("Failed to find span to end it.", new Object[0]);
            return;
        }
        if (span.getOptions().contains(Span.Options.RECORD_EVENTS)) {
            span.setStatus(AmqpTraceUtil.parseStatusMessage(statusMessage, throwable));
        }
        span.end();
    }

    public void addLink(Context eventContext) {
        Span span = this.getSpan(eventContext);
        if (span == null) {
            this.logger.warning("Failed to find span to link it.", new Object[0]);
            return;
        }
        Optional spanContextOptional = eventContext.getData((Object)"span-context");
        if (!spanContextOptional.isPresent()) {
            this.logger.warning("Failed to find Span context to link it.", new Object[0]);
            return;
        }
        if (!(spanContextOptional.get() instanceof SpanContext)) {
            this.logger.warning("Context in event is not of type SpanContext. Actual: {}", new Object[]{spanContextOptional.get().getClass()});
            return;
        }
        SpanContext spanContext = (SpanContext)spanContextOptional.get();
        span.addLink(Link.fromSpanContext((SpanContext)spanContext, (Link.Type)Link.Type.PARENT_LINKED_SPAN));
    }

    public Context extractContext(String diagnosticId, Context context) {
        return AmqpPropagationFormatUtil.extractContext(diagnosticId, context);
    }

    private Context startScopedSpan(String spanName, Context context) {
        Span span;
        Optional optionalSpanContext = context.getData((Object)"span-context");
        if (optionalSpanContext.isPresent() && optionalSpanContext.get() instanceof SpanContext) {
            span = this.startSpanWithRemoteParent(spanName, (SpanContext)optionalSpanContext.get());
        } else {
            SpanBuilder spanBuilder = this.startSpanWithExplicitParent(spanName, context);
            span = spanBuilder.setSpanKind(Span.Kind.SERVER).startSpan();
        }
        return context.addData((Object)"opentelemetry-span", (Object)span).addData((Object)"scope", (Object)TRACER.withSpan(span));
    }

    private SpanBuilder startSpanWithExplicitParent(String spanName, Context context) {
        Optional optionalSpanKey = context.getData((Object)"opentelemetry-span");
        Optional optionalSpanNameKey = context.getData((Object)"opentelemetry-span-name");
        Span parentSpan = null;
        String spanNameKey = null;
        if (optionalSpanKey.get() instanceof Span && optionalSpanNameKey.get() instanceof String) {
            parentSpan = context.getData((Object)"opentelemetry-span").orElse(TRACER.getCurrentSpan());
            spanNameKey = context.getData((Object)"opentelemetry-span-name").orElse(spanName);
        } else {
            this.logger.warning(String.format(Locale.US, "Parent span type is not of type Span, but type: %s. Failed to add span links.", optionalSpanKey.get() != null ? optionalSpanKey.get().getClass() : "null"), new Object[0]);
        }
        SpanBuilder spanBuilder = TRACER.spanBuilderWithExplicitParent(spanNameKey, parentSpan);
        return spanBuilder;
    }

    private Span startSpanWithRemoteParent(String spanName, SpanContext spanContext) {
        SpanBuilder spanBuilder = TRACER.spanBuilderWithRemoteParent(spanName, spanContext);
        spanBuilder.setSpanKind(Span.Kind.SERVER);
        return spanBuilder.startSpan();
    }

    private Context setContextData(Span span) {
        String traceparent = AmqpPropagationFormatUtil.getDiagnosticId(span.getContext());
        Context parentContext = new Context((Object)"diagnostic-id", (Object)traceparent).addData((Object)"span-context", (Object)span.getContext());
        return parentContext;
    }

    private static void addSpanRequestAttributes(Span span, Context context, String spanName) {
        if (context.getData((Object)"entity-path").isPresent() && context.getData((Object)"hostname").isPresent()) {
            span.putAttribute(COMPONENT, AttributeValue.stringAttributeValue((String)OpenTelemetryTracer.parseComponentValue(spanName)));
            span.putAttribute(MESSAGE_BUS_DESTINATION, AttributeValue.stringAttributeValue((String)context.getData((Object)"entity-path").get().toString()));
            span.putAttribute(PEER_ENDPOINT, AttributeValue.stringAttributeValue((String)context.getData((Object)"hostname").get().toString()));
        }
    }

    private static String parseComponentValue(String spanName) {
        return spanName.substring(spanName.indexOf(".") + 1, spanName.lastIndexOf("."));
    }

    private Span getSpan(Context context) {
        Optional spanOptional = context.getData((Object)"opentelemetry-span");
        if (!spanOptional.isPresent()) {
            this.logger.warning("Failed to find span in the context.", new Object[0]);
            return null;
        }
        Object value = spanOptional.get();
        if (!(value instanceof Span)) {
            this.logger.warning("Could not extract span. Data in {} is not of type Span. Actual class: {}", new Object[]{"opentelemetry-span", value.getClass()});
            return null;
        }
        return (Span)value;
    }
}

