/*
 * Decompiled with CFR 0.152.
 */
package com.azure.tracing.opentelemetry.implementation;

import com.azure.core.util.Context;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.TraceOptions;
import io.opencensus.trace.Tracestate;

public class AmqpPropagationFormatUtil {
    private AmqpPropagationFormatUtil() {
    }

    public static Context extractContext(String diagnosticId, Context context) {
        return context.addData((Object)"span-context", (Object)AmqpPropagationFormatUtil.fromDiagnosticId(diagnosticId));
    }

    public static String getDiagnosticId(SpanContext spanContext) {
        char[] chars = new char[55];
        chars[0] = 48;
        chars[1] = 48;
        chars[2] = 45;
        spanContext.getTraceId().copyLowerBase16To(chars, 3);
        chars[35] = 45;
        spanContext.getSpanId().copyLowerBase16To(chars, 36);
        chars[52] = 45;
        spanContext.getTraceOptions().copyLowerBase16To(chars, 53);
        return new String(chars);
    }

    private static SpanContext fromDiagnosticId(String diagnosticId) {
        if (diagnosticId == null || diagnosticId.length() < 55 || !diagnosticId.startsWith("00")) {
            return SpanContext.create((TraceId)TraceId.INVALID, (SpanId)SpanId.INVALID, (TraceOptions)TraceOptions.DEFAULT, (Tracestate)Tracestate.builder().build());
        }
        return SpanContext.create((TraceId)TraceId.fromLowerBase16((CharSequence)diagnosticId, (int)3), (SpanId)SpanId.fromLowerBase16((CharSequence)diagnosticId, (int)36), (TraceOptions)TraceOptions.fromLowerBase16((CharSequence)diagnosticId, (int)53), (Tracestate)Tracestate.builder().build());
    }
}

